/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.replicate.support;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloDatabaseException;
import br.com.elotech.di.domain.Agencia;
import br.com.elotech.di.domain.Bairro;
import br.com.elotech.di.domain.Banco;
import br.com.elotech.di.domain.Cidade;
import br.com.elotech.di.domain.Cnae;
import br.com.elotech.di.domain.Documento;
import br.com.elotech.di.domain.Entidade;
import br.com.elotech.di.domain.LeiAto;
import br.com.elotech.di.domain.Logradouro;
import br.com.elotech.di.domain.Modulo;
import br.com.elotech.di.domain.Pais;
import br.com.elotech.di.domain.Pessoa;
import br.com.elotech.di.domain.PessoaBanco;
import br.com.elotech.di.domain.PessoaContato;
import br.com.elotech.di.domain.PessoaEndereco;
import br.com.elotech.di.domain.TipoDocumento;
import br.com.elotech.di.domain.TipoLeiDocumento;
import br.com.elotech.di.domain.TipoLeiEscopo;
import br.com.elotech.di.domain.TipoLeiNatureza;
import br.com.elotech.di.domain.TipoLicitacao;
import br.com.elotech.di.domain.TipoLogradouro;
import br.com.elotech.di.domain.TipoVeiculoPublicacao;
import br.com.elotech.di.domain.UF;
import br.com.elotech.di.domain.Usuario;
import br.com.elotech.di.domain.VeiculoPublicacao;
import br.com.elotech.di.domain.aise.AiseAgencia;
import br.com.elotech.di.domain.aise.AiseAto;
import br.com.elotech.di.domain.aise.AiseBairro;
import br.com.elotech.di.domain.aise.AiseBanco;
import br.com.elotech.di.domain.aise.AiseCidade;
import br.com.elotech.di.domain.aise.AiseCnae;
import br.com.elotech.di.domain.aise.AiseEntidade;
import br.com.elotech.di.domain.aise.AiseLogradouro;
import br.com.elotech.di.domain.aise.AiseModulo;
import br.com.elotech.di.domain.aise.AisePais;
import br.com.elotech.di.domain.aise.AisePessoa;
import br.com.elotech.di.domain.aise.AiseTipoAto;
import br.com.elotech.di.domain.aise.AiseTipoDocumentoLegal;
import br.com.elotech.di.domain.aise.AiseTipoEscopoLei;
import br.com.elotech.di.domain.aise.AiseTipoLogradouro;
import br.com.elotech.di.domain.aise.AiseUnidadeFederacao;
import br.com.elotech.di.domain.aise.AiseUsuario;
import br.com.elotech.di.domain.aise.AiseVeiculoPublicacao;
import br.com.elotech.di.domain.apice.ApiceBairro;
import br.com.elotech.di.domain.apice.ApiceBanco;
import br.com.elotech.di.domain.apice.ApiceCidade;
import br.com.elotech.di.domain.apice.ApiceCnae;
import br.com.elotech.di.domain.apice.ApiceDocumentacao;
import br.com.elotech.di.domain.apice.ApiceEntidade;
import br.com.elotech.di.domain.apice.ApiceLogradouro;
import br.com.elotech.di.domain.apice.ApiceModulo;
import br.com.elotech.di.domain.apice.ApicePessoa;
import br.com.elotech.di.domain.apice.ApiceRamoAtividade;
import br.com.elotech.di.domain.apice.ApiceTipoLogradouro;
import br.com.elotech.di.domain.apice.ApiceUnidadeFederacao;
import br.com.elotech.di.domain.protocolo.ProtocoloBairro;
import br.com.elotech.di.domain.protocolo.ProtocoloCidade;
import br.com.elotech.di.domain.protocolo.ProtocoloEntidade;
import br.com.elotech.di.domain.protocolo.ProtocoloLogradouro;
import br.com.elotech.di.domain.protocolo.ProtocoloModulo;
import br.com.elotech.di.domain.protocolo.ProtocoloTipoLogradouro;
import br.com.elotech.di.domain.protocolo.ProtocoloUnidadeFederacao;
import br.com.elotech.di.domain.siscop.SiscopBanco;
import br.com.elotech.di.domain.siscop.SiscopCidade;
import br.com.elotech.di.domain.siscop.SiscopEntidade;
import br.com.elotech.di.domain.siscop.SiscopFornecedor;
import br.com.elotech.di.domain.siscop.SiscopLeisAtos;
import br.com.elotech.di.domain.siscop.SiscopModulo;
import br.com.elotech.di.domain.siscop.SiscopNaturezaLei;
import br.com.elotech.di.domain.siscop.SiscopOrgaoOficial;
import br.com.elotech.di.domain.siscop.SiscopTipoDocumentoLegal;
import br.com.elotech.di.domain.siscop.SiscopTipoEscopo;
import br.com.elotech.di.domain.siscop.SiscopTipoLogradouro;
import br.com.elotech.di.domain.siscop.SiscopTipoOrgaoOficial;
import br.com.elotech.di.domain.siscop.SiscopTiposLicitacao;
import br.com.elotech.di.domain.siscop.SiscopUnidadeFederacao;
import br.com.elotech.di.domain.support.EloDomain;
import br.com.elotech.di.jpa.hibernate.HibernateUtils;
import br.com.elotech.di.replicate.support.Replicable;
import br.com.elotech.di.replicate.support.ReplicatorInvalido;
import br.com.elotech.di.repository.Documentos;
import br.com.elotech.di.repository.Paises;
import br.com.elotech.di.repository.UnidadesFederacao;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceException;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.FlushMode;
import org.hibernate.NonUniqueResultException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.hibernate.transform.Transformers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.codec.Hex;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class ReplicatorFacade {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReplicatorFacade.class);
    private static final String FIELD_PESSOA = "pessoa";
    private static final String ID_NAME = "id";
    private static final String CODIGO_ID = "codigo";
    public static final String DESCRICAO_INVALIDA = "INVALIDA";
    public static final int MIN_LENGHT_NOME = 4;
    @Autowired
    private UnidadesFederacao ufs;
    @Autowired
    private Paises paises;
    @Autowired
    private Documentos documentos;
    @Autowired
    private ReplicatorInvalido replicatorInvalido;
    @PersistenceContext
    private EntityManager em;

    public static String defaultString(String str) {
        return ReplicatorFacade.defaultString((String)str, (int)0);
    }

    public static <T extends EloEntity<?>> String hashCodeEloEntity(T eloEntity) {
        if (eloEntity == null || eloEntity.getId() == null) {
            return "";
        }
        return new String(Hex.encode((byte[])eloEntity.getId().toString().getBytes()));
    }

    public static String hashCodeString(String str) {
        if (str == null) {
            return "";
        }
        return ReplicatorFacade.hashCodeStringCaseSensitive((String)str.toLowerCase(LocaleContextHolder.getLocale()));
    }

    public static String hashCodeStringCaseSensitive(String str) {
        if (str == null) {
            return "";
        }
        return new String(Hex.encode((byte[])str.getBytes()));
    }

    public static String defaultString(String str, int minLenght) {
        String strResult = StringUtils.defaultIfEmpty((String)str, (String)"INVALIDA");
        if (strResult.length() < minLenght) {
            return "INVALIDA";
        }
        return strResult;
    }

    private <T> Criteria createCriteria(Class<T> type, Projection projections, Criterion restrictions) {
        Session session = (Session)this.em.unwrap(Session.class);
        return session.createCriteria(type).setProjection(projections).add(restrictions).setResultTransformer(Transformers.aliasToBean(type)).setFlushMode(FlushMode.MANUAL).setCacheable(true);
    }

    private <T> T getEntityWithFilterAndColumnWhereAndRestrictions(Class<T> type, String idName, Serializable id, String columnWhereName, Criterion restrictions, boolean throwExceptionNotFound) {
        ProjectionList projections = Projections.projectionList().add(Projections.alias((Projection)Projections.property((String)idName), (String)idName));
        projections.add(Projections.alias((Projection)Projections.property((String)columnWhereName), (String)columnWhereName));
        Criteria criteria = this.createCriteria(type, (Projection)projections, (Criterion)Restrictions.eq((String)columnWhereName, (Object)id));
        if (restrictions != null) {
            criteria.add(restrictions);
        }
        try {
            Object result = criteria.uniqueResult();
            if (throwExceptionNotFound && result == null) {
                throw new EntityNotFoundException(String.format("Not found class %s finding by %s with value " + String.valueOf(id), type.getSimpleName(), columnWhereName));
            }
            return (T)result;
        }
        catch (NonUniqueResultException ex) {
            String message = String.format("Foi encontrado mais de 1 registro para a classe %s com o campo %s com valor igual a %s", type.getSimpleName(), columnWhereName, id);
            log.error(message, (Throwable)ex);
            throw new EloDatabaseException(message, (Throwable)ex);
        }
    }

    private <T> T getEntityWithFilterAndColumnWhere(Class<T> type, String idName, Serializable id, String columnWhereName) {
        return (T)this.getEntityWithFilterAndColumnWhereAndRestrictions(type, idName, id, columnWhereName, null, true);
    }

    public <K extends Serializable, T extends Replicable<?, K>> T getLegadoWithFilter(Class<T> type, String idName, K idUnico) {
        return (T)((Replicable)this.getEntityWithFilterAndColumnWhere(type, idName, idUnico, "idUnico"));
    }

    private <T> T getTipoLei(Class<T> classTipoLei, Long codigo) {
        try {
            Session session = (Session)this.em.unwrap(Session.class);
            return (T)session.createQuery("from " + classTipoLei.getSimpleName() + " where codigo = :codigo").setParameter("codigo", (Object)codigo).setHibernateFlushMode(FlushMode.MANUAL).setMaxResults(1).uniqueResult();
        }
        catch (NoResultException ex) {
            throw new PersistenceException(classTipoLei.getName() + " n\u00e3o encontrada com c\u00f3digo " + codigo, (Throwable)ex);
        }
    }

    public <K extends Serializable, T extends Replicable<?, K>> T getLegado(Class<T> type, String idName, EloEntity<K> eloEntity) {
        if (eloEntity == null) {
            return null;
        }
        return (T)this.getLegadoWithFilter(type, idName, eloEntity.getId());
    }

    public <K extends Serializable, T extends Replicable<?, K>> T getLegadoNotFoundIgnore(Class<T> type, String idName, EloEntity<K> eloEntity) {
        if (eloEntity == null) {
            return null;
        }
        return (T)((Replicable)this.getEntityWithFilterAndColumnWhereAndRestrictions(type, idName, eloEntity.getId(), "idUnico", null, false));
    }

    public ApicePessoa getApicePessoa(Long idUnico) {
        return (ApicePessoa)this.getLegadoWithFilter(ApicePessoa.class, "pessoa", (Serializable)idUnico);
    }

    public ApiceCidade getApiceCidade(Cidade cidade) {
        if (cidade != null) {
            return this.getApiceCidade(cidade.getId());
        }
        return null;
    }

    public ApiceCidade getApiceCidade(Long idUnico) {
        return (ApiceCidade)this.getLegadoWithFilter(ApiceCidade.class, "codigo", (Serializable)idUnico);
    }

    public ApiceBanco getApiceBanco(Long idUnico) {
        return (ApiceBanco)this.getLegadoWithFilter(ApiceBanco.class, "codigo", (Serializable)idUnico);
    }

    public ApiceBairro getApiceBairro(Bairro bairro) {
        return (ApiceBairro)this.getLegado(ApiceBairro.class, "pk", (EloEntity)bairro);
    }

    public ApiceBairro getApiceBairro(Long idUnico) {
        return (ApiceBairro)this.getLegadoWithFilter(ApiceBairro.class, "pk", (Serializable)idUnico);
    }

    public SiscopBanco getSiscopBanco(Long idUnico) {
        return (SiscopBanco)this.getLegadoWithFilter(SiscopBanco.class, "codigo", (Serializable)idUnico);
    }

    public ApiceUnidadeFederacao getApiceUF(Long idUnico) {
        return (ApiceUnidadeFederacao)this.getLegadoWithFilter(ApiceUnidadeFederacao.class, "sigla", (Serializable)idUnico);
    }

    public ApiceLogradouro getApiceLogradouro(Logradouro logradouro) {
        return (ApiceLogradouro)this.getLegado(ApiceLogradouro.class, "pk", (EloEntity)logradouro);
    }

    public ApiceLogradouro getApiceLogradouro(Long idUnico) {
        return (ApiceLogradouro)this.getLegadoWithFilter(ApiceLogradouro.class, "pk", (Serializable)idUnico);
    }

    public AiseCidade getAiseCidade(Cidade cidade) {
        if (cidade != null) {
            return this.getAiseCidade(cidade.getId());
        }
        return null;
    }

    public AiseCidade getAiseCidade(Long idUnico) {
        return (AiseCidade)this.getLegadoWithFilter(AiseCidade.class, "codigo", (Serializable)idUnico);
    }

    public AiseBanco getAiseBanco(Long idUnico) {
        return (AiseBanco)this.getLegadoWithFilter(AiseBanco.class, "codigo", (Serializable)idUnico);
    }

    public ApiceTipoLogradouro getApiceTipoLogradouro(Long idUnico) {
        return (ApiceTipoLogradouro)this.getLegadoWithFilter(ApiceTipoLogradouro.class, "codigo", (Serializable)idUnico);
    }

    public AiseUnidadeFederacao getAiseUF(Long idUnico) {
        return (AiseUnidadeFederacao)this.getLegadoWithFilter(AiseUnidadeFederacao.class, "pk", (Serializable)idUnico);
    }

    public AiseTipoLogradouro getAiseTipoLogradouro(Long idUnico) {
        return (AiseTipoLogradouro)this.getLegadoWithFilter(AiseTipoLogradouro.class, "codigo", (Serializable)idUnico);
    }

    public AiseAgencia getAiseAgencia(Long idUnico) {
        return (AiseAgencia)this.getLegadoWithFilter(AiseAgencia.class, "pk", (Serializable)idUnico);
    }

    public AiseBairro getAiseBairro(Bairro bairro) {
        return (AiseBairro)this.getLegado(AiseBairro.class, "pk", (EloEntity)bairro);
    }

    public AiseBairro getAiseBairro(Long idUnico) {
        return (AiseBairro)this.getLegadoWithFilter(AiseBairro.class, "pk", (Serializable)idUnico);
    }

    public AiseLogradouro getAiseLogradouro(Logradouro logradouro) {
        return (AiseLogradouro)this.getLegado(AiseLogradouro.class, "pk", (EloEntity)logradouro);
    }

    public AiseLogradouro getAiseLogradouro(Long idUnico) {
        return (AiseLogradouro)this.getLegadoWithFilter(AiseLogradouro.class, "pk", (Serializable)idUnico);
    }

    public AisePais getAisePais(Long idUnico) {
        return (AisePais)this.getLegadoWithFilter(AisePais.class, "codigo", (Serializable)idUnico);
    }

    public SiscopCidade getSiscopCidade(Long idUnico) {
        return (SiscopCidade)this.getLegadoWithFilter(SiscopCidade.class, "codigo", (Serializable)idUnico);
    }

    public SiscopUnidadeFederacao getSiscopUF(Long idUnico) {
        return (SiscopUnidadeFederacao)this.getLegadoWithFilter(SiscopUnidadeFederacao.class, "sigla", (Serializable)idUnico);
    }

    public SiscopTipoLogradouro getSiscopTipoLogradouro(Long idUnico) {
        return (SiscopTipoLogradouro)this.getLegadoWithFilter(SiscopTipoLogradouro.class, "codigo", (Serializable)idUnico);
    }

    public ProtocoloUnidadeFederacao getProtocoloUF(Long idUnico) {
        return (ProtocoloUnidadeFederacao)this.getLegadoWithFilter(ProtocoloUnidadeFederacao.class, "sigla", (Serializable)idUnico);
    }

    public ProtocoloCidade getProtocoloCidade(Cidade cidade) {
        return (ProtocoloCidade)this.getLegado(ProtocoloCidade.class, "codigo", (EloEntity)cidade);
    }

    public ProtocoloCidade getProtocoloCidade(Long idUnico) {
        return (ProtocoloCidade)this.getLegadoWithFilter(ProtocoloCidade.class, "codigo", (Serializable)idUnico);
    }

    public ProtocoloBairro getProtocoloBairro(Bairro bairro) {
        return (ProtocoloBairro)this.getLegado(ProtocoloBairro.class, "codigo", (EloEntity)bairro);
    }

    public ProtocoloBairro getProtocoloBairro(Long idUnico) {
        return (ProtocoloBairro)this.getLegadoWithFilter(ProtocoloBairro.class, "codigo", (Serializable)idUnico);
    }

    public ProtocoloTipoLogradouro getProtocoloTipoLogradouro(Long idUnico) {
        return (ProtocoloTipoLogradouro)this.getLegadoWithFilter(ProtocoloTipoLogradouro.class, "codigo", (Serializable)idUnico);
    }

    public ProtocoloLogradouro getProtocoloLogradouro(Logradouro logradouro) {
        return (ProtocoloLogradouro)this.getLegado(ProtocoloLogradouro.class, "codigo", (EloEntity)logradouro);
    }

    public ProtocoloLogradouro getProtocoloLogradouro(Long idUnico) {
        return (ProtocoloLogradouro)this.getLegadoWithFilter(ProtocoloLogradouro.class, "codigo", (Serializable)idUnico);
    }

    public UF findUFBySigla(String sigla) {
        return this.ufs.findBySigla(sigla);
    }

    public static String hashCodeLong(Long codigo) {
        if (codigo == null) {
            return "";
        }
        return codigo.toString();
    }

    public <K extends Serializable, T extends EloDomain<K>> T createReAttachEloDomain(Class<T> clazz, K id) {
        if (id == null) {
            return null;
        }
        return (T)HibernateUtils.createReAttachEloDomain(clazz, id, (EntityManager)this.em);
    }

    public Cidade createOrGetCidadeInvalida() {
        return this.replicatorInvalido.createOrGetCidadeInvalida();
    }

    public Pais createOrGetPaisInvalido() {
        return this.replicatorInvalido.createOrGetPaisInvalido();
    }

    public UF createOrGetUfInvalida() {
        return this.replicatorInvalido.createOrGetUfInvalida();
    }

    public TipoLogradouro createOrGetTipoLogradouroInvalida() {
        return this.replicatorInvalido.createOrGetTipoLogradouroInvalida();
    }

    public static <U extends Serializable> U defaultIdUnicoIfNull(Replicable<?, U> replicable) {
        if (replicable == null) {
            return null;
        }
        return (U)replicable.getIdUnico();
    }

    public static void checkEnderecoPrincipalIfDontHave(Pessoa pessoa) {
        if (!pessoa.getEnderecos().isEmpty() && pessoa.getEndereco() == null) {
            ((PessoaEndereco)pessoa.getEnderecos().get(0)).setPrincipal(Boolean.valueOf(true));
        }
    }

    public static void checkContatoPrincipalIfDontHave(Pessoa pessoa) {
        if (!pessoa.getContatos().isEmpty() && pessoa.getContato() == null) {
            ((PessoaContato)pessoa.getContatos().get(0)).setPrincipal(Boolean.valueOf(true));
        }
    }

    public static void checkContaBancariaPrincipalIfDontHave(Pessoa pessoa) {
        if (!pessoa.getBancosPessoa().isEmpty() && pessoa.getBanco() == null) {
            ((PessoaBanco)pessoa.getBancosPessoa().get(0)).getConta().setPrincipal(Boolean.valueOf(true));
        }
    }

    public Bairro createOrGetBairroInvalido(String descricao, Cidade cidade) {
        return this.replicatorInvalido.createOrGetBairroInvalido(descricao, cidade);
    }

    public Logradouro createOrGetLogradouroInvalido(String descricao, Cidade cidade) {
        return this.replicatorInvalido.createOrGetLogradouroInvalido(descricao, cidade);
    }

    public synchronized Agencia createOrUpdateAgencia(String codigo, Banco banco, Replicable<Cidade, Long> cidade) {
        Cidade cidadeAttached = null;
        if (!Objects.isNull(cidade)) {
            cidadeAttached = (Cidade)this.createReAttachEloDomain(Cidade.class, (Serializable)((Long)cidade.getIdUnico()));
        }
        return this.replicatorInvalido.createOrUpdateAgencia(codigo, banco, cidadeAttached);
    }

    public ApiceCnae getApiceCnae(Long idUnico) {
        return (ApiceCnae)this.getLegadoWithFilter(ApiceCnae.class, "codigo", (Serializable)idUnico);
    }

    public AiseCnae getAiseCnae(Cnae cnae) {
        return (AiseCnae)this.getLegado(AiseCnae.class, "id", (EloEntity)cnae);
    }

    public ApiceRamoAtividade getApiceRamoAtividade(Long idUnico) {
        return (ApiceRamoAtividade)this.getLegadoWithFilter(ApiceRamoAtividade.class, "codigo", (Serializable)idUnico);
    }

    public ApiceDocumentacao getApiceDocumentacao(Long idUnico) {
        return (ApiceDocumentacao)this.getLegadoWithFilter(ApiceDocumentacao.class, "codigo", (Serializable)idUnico);
    }

    public Documento findFirstByTipoDocumento(TipoDocumento tipoDocumento) {
        return this.documentos.findFirstByTipoDocumento(tipoDocumento);
    }

    public Documento getDocumentoById(Long idUnico) {
        return (Documento)this.documentos.findOne((Object)idUnico);
    }

    public SiscopEntidade getSiscopEntidade(Entidade entidade) {
        return (SiscopEntidade)this.getLegado(SiscopEntidade.class, "id", (EloEntity)entidade);
    }

    public SiscopTipoEscopo getSiscopTipoLeiEscopo(TipoLeiEscopo tipoLeiEscopo) {
        if (tipoLeiEscopo == null) {
            return null;
        }
        return (SiscopTipoEscopo)this.getEntityWithFilterAndColumnWhereAndRestrictions(SiscopTipoEscopo.class, "id", (Serializable)tipoLeiEscopo.getCodigo(), "codigo", (Criterion)Restrictions.eq((String)"versao", (Object)1L), true);
    }

    public TipoLeiNatureza getTipoLeiNaturezaByCodigo(Long codigo) {
        if (codigo == null || codigo == 0L) {
            return (TipoLeiNatureza)this.getTipoLei(TipoLeiNatureza.class, TipoLeiNatureza.OUTROS);
        }
        return (TipoLeiNatureza)this.getTipoLei(TipoLeiNatureza.class, codigo);
    }

    public SiscopNaturezaLei getSiscopTipoLeiNatureza(TipoLeiNatureza tipoLeiNatureza) {
        if (tipoLeiNatureza == null) {
            return null;
        }
        return (SiscopNaturezaLei)this.getEntityWithFilterAndColumnWhere(SiscopNaturezaLei.class, "id", (Serializable)tipoLeiNatureza.toSiscopNaturezaLeiCodigo(), "codigo");
    }

    public SiscopTipoDocumentoLegal getSiscopTipoLeiDocumento(TipoLeiDocumento tipoLeiDocumento) {
        if (tipoLeiDocumento == null) {
            return null;
        }
        return (SiscopTipoDocumentoLegal)this.getEntityWithFilterAndColumnWhere(SiscopTipoDocumentoLegal.class, "id", (Serializable)tipoLeiDocumento.getCodigo(), "codigo");
    }

    public AiseEntidade getAiseEntidade(Entidade entidade) {
        return (AiseEntidade)this.getLegado(AiseEntidade.class, "id", (EloEntity)entidade);
    }

    public AiseTipoAto getAiseTipoLeiNatureza(TipoLeiNatureza tipoLeiNatureza) {
        if (tipoLeiNatureza == null) {
            return null;
        }
        return (AiseTipoAto)this.getEntityWithFilterAndColumnWhere(AiseTipoAto.class, "id", (Serializable)tipoLeiNatureza.getId(), "id");
    }

    public AiseTipoDocumentoLegal getAiseTipoLeiDocumento(TipoLeiDocumento tipoLeiDocumento) {
        if (tipoLeiDocumento == null) {
            return null;
        }
        return (AiseTipoDocumentoLegal)this.getEntityWithFilterAndColumnWhere(AiseTipoDocumentoLegal.class, "id", (Serializable)tipoLeiDocumento.getCodigo(), "codigo");
    }

    public AiseTipoEscopoLei getAiseTipoLeiEscopo(TipoLeiEscopo tipoLeiEscopo) {
        if (tipoLeiEscopo == null) {
            return null;
        }
        return (AiseTipoEscopoLei)this.getEntityWithFilterAndColumnWhere(AiseTipoEscopoLei.class, "id", (Serializable)tipoLeiEscopo.getCodigo(), "codigo");
    }

    public TipoLeiDocumento getTipoLeiDocumentoByCodigo(Long codigo) {
        if (codigo == null) {
            return null;
        }
        return (TipoLeiDocumento)this.getTipoLei(TipoLeiDocumento.class, codigo);
    }

    public TipoLeiEscopo getTipoLeiEscopoByCodigo(Long codigo) {
        if (codigo == null) {
            return (TipoLeiEscopo)this.getTipoLei(TipoLeiEscopo.class, TipoLeiEscopo.OUTRO_TIPO_ESCOPO);
        }
        return (TipoLeiEscopo)this.getTipoLei(TipoLeiEscopo.class, codigo);
    }

    public SiscopFornecedor getSiscopPessoa(Pessoa pessoa) {
        return (SiscopFornecedor)this.getLegado(SiscopFornecedor.class, "codigo", (EloEntity)pessoa);
    }

    public SiscopLeisAtos getSiscopLeiAto(LeiAto leiAto) {
        return (SiscopLeisAtos)this.getLegado(SiscopLeisAtos.class, "id", (EloEntity)leiAto);
    }

    public SiscopTiposLicitacao getSiscopTipoLicitacao(TipoLicitacao tipoLicitacao) {
        if (tipoLicitacao == null) {
            return null;
        }
        return (SiscopTiposLicitacao)this.getEntityWithFilterAndColumnWhere(SiscopTiposLicitacao.class, "id", (Serializable)((Object)tipoLicitacao.getCodContab()), "id");
    }

    public SiscopTipoOrgaoOficial getSiscopTipoVeiculoPublicacao(TipoVeiculoPublicacao tipoVeiculoPublicacao) {
        if (tipoVeiculoPublicacao == null) {
            return null;
        }
        return (SiscopTipoOrgaoOficial)this.getEntityWithFilterAndColumnWhereAndRestrictions(SiscopTipoOrgaoOficial.class, "id", (Serializable)tipoVeiculoPublicacao.getCodigo(), "codigo", Restrictions.isNull((String)"uf"), true);
    }

    public TipoLicitacao getTipoLicitacaoBySiscop(SiscopTiposLicitacao tipoLicitacao) {
        if (tipoLicitacao == null) {
            return null;
        }
        Session session = (Session)this.em.unwrap(Session.class);
        return (TipoLicitacao)session.createQuery("from TipoLicitacao where codigoContabilidade = :codigo").setParameter("codigo", (Object)tipoLicitacao.getId()).setHibernateFlushMode(FlushMode.MANUAL).uniqueResult();
    }

    public Entidade getEntidadePrincipal() {
        Session session = (Session)this.em.unwrap(Session.class);
        Entidade result = (Entidade)session.createQuery("from Entidade where entidadeprincipal = :codigo").setParameter("codigo", (Object)"S").setHibernateFlushMode(FlushMode.MANUAL).setMaxResults(1).uniqueResult();
        if (result == null) {
            throw new EntityNotFoundException("Entidade principal n\u00e3o foi definida.");
        }
        return result;
    }

    public TipoVeiculoPublicacao getTipoVeiculoPublicacaoBySiscop(SiscopTipoOrgaoOficial tipoOrgaoOficial) {
        if (tipoOrgaoOficial == null) {
            return null;
        }
        Session session = (Session)this.em.unwrap(Session.class);
        return (TipoVeiculoPublicacao)session.createQuery("from TipoVeiculoPublicacao where codigo = :codigo and uf is null").setParameter("codigo", (Object)tipoOrgaoOficial.getCodigo()).setHibernateFlushMode(FlushMode.MANUAL).uniqueResult();
    }

    public AiseAto getAiseLeiAto(LeiAto leiAto) {
        return (AiseAto)this.getLegado(AiseAto.class, "id", (EloEntity)leiAto);
    }

    public AiseModulo getAiseModulo(Modulo modulo) {
        return (AiseModulo)this.getLegado(AiseModulo.class, "id", (EloEntity)modulo);
    }

    public SiscopOrgaoOficial getSiscopVeiculoPublicacao(VeiculoPublicacao veiculoPublicacao) {
        return (SiscopOrgaoOficial)this.getLegado(SiscopOrgaoOficial.class, "id", (EloEntity)veiculoPublicacao);
    }

    public AiseVeiculoPublicacao getAiseVeiculoPublicacao(VeiculoPublicacao veiculoPublicacao) {
        return (AiseVeiculoPublicacao)this.getLegado(AiseVeiculoPublicacao.class, "id", (EloEntity)veiculoPublicacao);
    }

    public AisePessoa getAisePessoaByCPF(String cpf) {
        Criteria criteria = this.createCriteria(AisePessoa.class, (Projection)Projections.projectionList().add(Projections.alias((Projection)Projections.property((String)"pessoa"), (String)"pessoa")).add(Projections.alias((Projection)Projections.property((String)"inativo"), (String)"inativo")), (Criterion)Restrictions.eq((String)"cnpjCpf", (Object)cpf));
        List listPessoas = criteria.list();
        if (listPessoas.size() == 1) {
            return (AisePessoa)listPessoas.get(0);
        }
        Optional<AisePessoa> pessoa = listPessoas.stream().filter(p -> p.getInativo() == false).findFirst();
        if (pessoa.isPresent()) {
            return pessoa.get();
        }
        return null;
    }

    public AisePessoa getAisePessoa(Pessoa pessoa) {
        return (AisePessoa)this.getLegadoNotFoundIgnore(AisePessoa.class, "pessoa", (EloEntity)pessoa);
    }

    public AiseUsuario getAiseUsuario(Usuario usuario) {
        return (AiseUsuario)this.getLegado(AiseUsuario.class, "id", (EloEntity)usuario);
    }

    public SiscopModulo getSiscopModulo(Modulo modulo) {
        return (SiscopModulo)this.getLegado(SiscopModulo.class, "id", (EloEntity)modulo);
    }

    public ApiceEntidade getApiceEntidade(Entidade entidade) {
        return (ApiceEntidade)this.getLegado(ApiceEntidade.class, "id", (EloEntity)entidade);
    }

    public ApiceModulo getApiceModulo(Modulo modulo) {
        return (ApiceModulo)this.getLegado(ApiceModulo.class, "id", (EloEntity)modulo);
    }

    public ProtocoloEntidade getProtocoloEntidade(Entidade entidade) {
        return (ProtocoloEntidade)this.getLegado(ProtocoloEntidade.class, "id", (EloEntity)entidade);
    }

    public ProtocoloModulo getProtocoloModulo(Modulo modulo) {
        return (ProtocoloModulo)this.getLegado(ProtocoloModulo.class, "id", (EloEntity)modulo);
    }

    public String getUsuario() {
        if (SecurityContextHolder.getContext() != null && SecurityContextHolder.getContext().getAuthentication() != null) {
            return SecurityContextHolder.getContext().getAuthentication().getName();
        }
        return null;
    }

    public EntityManager getEm() {
        return this.em;
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        return (T)this.em.find(entityClass, primaryKey);
    }

    public Pais getPaisDefault() {
        return this.paises.findByDescricaoIgnoreCase("Brasil").orElse(null);
    }

    public boolean existsUnicoEntidades() {
        Long count = (Long)((Query)this.em.createQuery("select count(*) from Entidade", Long.class).unwrap(Query.class)).setHibernateFlushMode(FlushMode.MANUAL).uniqueResult();
        return count > 0L;
    }
}

