/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.replicate.siscop;

import br.com.elotech.di.domain.Entidade;
import br.com.elotech.di.domain.LeiAto;
import br.com.elotech.di.domain.Pessoa;
import br.com.elotech.di.domain.VeiculoPublicacao;
import br.com.elotech.di.domain.siscop.SiscopEntidade;
import br.com.elotech.di.domain.siscop.SiscopFornecedor;
import br.com.elotech.di.domain.siscop.SiscopLeisAtos;
import br.com.elotech.di.domain.siscop.SiscopOrgaoOficial;
import br.com.elotech.di.replicate.support.AbstractReplicatorVeiculoPublicacao;
import br.com.elotech.di.replicate.support.Replicable;
import br.com.elotech.di.utils.EloNumberUtils;
import java.io.Serializable;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class ReplicatorVeiculoPublicacaoSiscop
extends AbstractReplicatorVeiculoPublicacao<SiscopOrgaoOficial> {
    public SiscopOrgaoOficial from(VeiculoPublicacao unico, SiscopOrgaoOficial legado) {
        super.from(unico, (Replicable)legado);
        legado.setNumeroOperacao(unico.getCodigoOperacao());
        legado.setDataEnvio(unico.getDataEnvio());
        legado.setMotivoBaixa(unico.getMotivoBaixa());
        legado.setObservacao(unico.getObservacao());
        legado.setDataBaixa(unico.getDataBaixa());
        legado.setDataInicio(unico.getDataCadastro());
        legado.setEntidadeLicitacao(this.getReplicatorFacade().getSiscopEntidade(unico.getEntidadeLicitacao()));
        legado.setFornecedor(this.getReplicatorFacade().getSiscopPessoa(unico.getPessoa()));
        legado.getId().setEntidade(this.getReplicatorFacade().getSiscopEntidade(unico.getEntidade()));
        legado.setTipoLicitacao(this.getReplicatorFacade().getSiscopTipoLicitacao(unico.getTipoLicitacao()));
        legado.setTipoOrgaoOficial(this.getReplicatorFacade().getSiscopTipoVeiculoPublicacao(unico.getTipoVeiculoPublicacao()));
        legado.setLeiato(this.getReplicatorFacade().getSiscopLeiAto(unico.getLeiAto()));
        legado.setAnoLicitacao(unico.getAnoLicitacao());
        legado.setNumeroLicitacao(unico.getNumeroLicitacao());
        legado.setPossuiLicitacao(unico.getPossuiLicitacao());
        legado.setIdUnico(unico.getId());
        return legado;
    }

    public VeiculoPublicacao to(SiscopOrgaoOficial legado, VeiculoPublicacao unico) {
        unico.setAnoLicitacao(legado.getAnoLicitacao());
        unico.setCodigoAtosPessoal(EloNumberUtils.toString((Long)legado.getNumeroOperacao()));
        unico.setCodigoOperacao(legado.getNumeroOperacao());
        unico.setDataBaixa(legado.getDataBaixa());
        unico.setDataCadastro(legado.getDataInicio());
        unico.setDataEnvio(legado.getDataEnvio());
        unico.setEntidade((Entidade)this.getReplicatorFacade().createReAttachEloDomain(Entidade.class, (Serializable)legado.getId().getEntidade().getIdUnico()));
        unico.setId(legado.getIdUnico());
        unico.setMotivoBaixa(legado.getMotivoBaixa());
        unico.setNumeroLicitacao(legado.getNumeroLicitacao());
        unico.setObservacao(legado.getObservacao());
        unico.setPossuiLicitacao(legado.getPossuiLicitacao());
        unico.setTipoLicitacao(this.getReplicatorFacade().getTipoLicitacaoBySiscop(legado.getTipoLicitacao()));
        unico.setTipoVeiculoPublicacao(this.getReplicatorFacade().getTipoVeiculoPublicacaoBySiscop(legado.getTipoOrgaoOficial()));
        SiscopLeisAtos leiAtoSiscop = Optional.ofNullable(legado.getLeiato()).orElse(new SiscopLeisAtos());
        SiscopEntidade entidadeSiscop = Optional.ofNullable(legado.getEntidadeLicitacao()).orElse(new SiscopEntidade());
        SiscopFornecedor fornecedorSiscop = Optional.ofNullable(legado.getFornecedor()).orElse(new SiscopFornecedor());
        unico.setLeiAto((LeiAto)this.getReplicatorFacade().createReAttachEloDomain(LeiAto.class, (Serializable)leiAtoSiscop.getIdUnico()));
        unico.setEntidadeLicitacao((Entidade)this.getReplicatorFacade().createReAttachEloDomain(Entidade.class, (Serializable)entidadeSiscop.getIdUnico()));
        unico.setPessoa((Pessoa)this.getReplicatorFacade().createReAttachEloDomain(Pessoa.class, (Serializable)fornecedorSiscop.getIdUnico()));
        return unico;
    }
}

