/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.replicate.siscop;

import br.com.elotech.core.utils.Cipher;
import br.com.elotech.di.domain.Entidade;
import br.com.elotech.di.domain.Grupo;
import br.com.elotech.di.domain.Modulo;
import br.com.elotech.di.domain.Rg;
import br.com.elotech.di.domain.Usuario;
import br.com.elotech.di.domain.UsuarioEntidade;
import br.com.elotech.di.domain.UsuarioModulo;
import br.com.elotech.di.domain.siscop.SiscopEntidade;
import br.com.elotech.di.domain.siscop.SiscopModulo;
import br.com.elotech.di.domain.siscop.SiscopUsuario;
import br.com.elotech.di.domain.siscop.SiscopUsuarioEntidade;
import br.com.elotech.di.domain.siscop.SiscopUsuarioModulo;
import br.com.elotech.di.replicate.support.AbstractReplicatorUsuario;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;

@Component
public class ReplicatorUsuarioSiscop
extends AbstractReplicatorUsuario<Usuario, Long, SiscopUsuario> {
    private static final String KEY = "UOLNEWS";
    private final PasswordEncoder passwordEncoder;

    @Autowired
    public ReplicatorUsuarioSiscop(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public SiscopUsuario from(Usuario unico, SiscopUsuario legado) {
        legado.setAtivo(unico.getAtivo());
        legado.setId(StringUtils.defaultIfBlank((String)legado.getId(), (String)unico.getUsuario()));
        legado.setIdUnico(unico.getId());
        legado.setSenha(StringUtils.substring((String)unico.getSenha(), (int)0, (int)14));
        legado.setCpf(unico.getCpf());
        legado.setDescricaoCargo(unico.getCargo());
        legado.setMatricula(unico.getMatricula());
        legado.setNome(unico.getNome());
        legado.setEmail(unico.getEmail());
        if (unico.getRg() != null) {
            legado.setOrgaoEmissor(unico.getRg().getOrgaoEmissor());
            legado.setRg(unico.getRg().getNumero());
        }
        if (this.getReplicatorFacade().existsUnicoEntidades()) {
            this.createLegadoEntidades(unico, legado);
        }
        this.createLegadoModulos(unico, legado);
        if (unico.getGrupos().contains(Grupo.GRUPO_ADMINISTRADORES) || unico.getGrupos().contains(Grupo.GRUPO_ADMINISTRADORES_CONTABIL)) {
            legado.maskAsRoot();
        }
        return legado;
    }

    private void createLegadoModulos(Usuario unico, SiscopUsuario legado) {
        legado.getModulos().clear();
        List modulos = unico.getModulos();
        for (UsuarioModulo usuarioModulo : modulos) {
            SiscopModulo siscopModulo = this.getReplicatorFacade().getSiscopModulo(usuarioModulo.getModulo());
            legado.getModulos().add(SiscopUsuarioModulo.of((SiscopUsuario)legado, (SiscopModulo)siscopModulo).withPrioritario(usuarioModulo.getPrincipal()));
        }
    }

    private void createLegadoEntidades(Usuario unico, SiscopUsuario legado) {
        legado.getEntidades().clear();
        List entidades = unico.getEntidades();
        for (UsuarioEntidade usuarioEntidade : entidades) {
            SiscopEntidade siscopEntidade = this.getReplicatorFacade().getSiscopEntidade(usuarioEntidade.getEntidade());
            if (Objects.nonNull(siscopEntidade)) {
                legado.getEntidades().add(SiscopUsuarioEntidade.of((SiscopUsuario)legado, (SiscopEntidade)siscopEntidade).withPadrao(usuarioEntidade.getPrincipal()));
                continue;
            }
            this.getLog().debug("N\u00e3o foi encontrado entidade do legado para o usu\u00e1rio \u00fanico {}", (Object)unico);
        }
    }

    public Usuario to(SiscopUsuario legado, Usuario unico) {
        unico.setId(legado.getIdUnico());
        unico.setNome(legado.getNome());
        unico.setCpf(legado.getCpf());
        unico.setMatricula(legado.getMatricula());
        unico.setCargo(legado.getDescricaoCargo());
        unico.setRg(new Rg().withNumero(legado.getRg()).withOrgaoEmissor(legado.getOrgaoEmissor()));
        unico.setEmail(legado.getEmail());
        if (unico.hasToSetUsuario()) {
            unico.setUsuario(legado.getId());
            unico.setUsuarioOriginal(legado.getId());
        }
        unico.setAtivo(legado.getAtivo());
        this.createUnicoEntidades(unico, legado);
        this.createUnicoModulos(unico, legado);
        this.createUnicoGrupos(unico, legado);
        if (StringUtils.isBlank((String)unico.getSenha()) && StringUtils.isNotBlank((String)legado.getSenha())) {
            String decodedPwd = Cipher.encrypt((String)legado.getSenha().trim(), (String)KEY);
            unico.setSenha(this.passwordEncoder.encode((CharSequence)decodedPwd));
        }
        return unico;
    }

    private void createUnicoModulos(Usuario unico, SiscopUsuario legado) {
        unico.getModulos().clear();
        Set legadoModulos = legado.getModulos();
        for (SiscopUsuarioModulo siscopUsuarioModulo : legadoModulos) {
            Modulo modulo = (Modulo)this.getReplicatorFacade().createReAttachEloDomain(Modulo.class, (Serializable)siscopUsuarioModulo.getPk().getModulo().getIdUnico());
            unico.getModulos().add(UsuarioModulo.of((Modulo)modulo).withPrincipal(siscopUsuarioModulo.getPrioritario()));
        }
    }

    private void createUnicoEntidades(Usuario unico, SiscopUsuario legado) {
        unico.getEntidades().clear();
        Set legadoEntidades = legado.getEntidades();
        for (SiscopUsuarioEntidade siscopUsuarioEntidade : legadoEntidades) {
            Entidade entidade = (Entidade)this.getReplicatorFacade().createReAttachEloDomain(Entidade.class, (Serializable)siscopUsuarioEntidade.getPk().getEntidade().getIdUnico());
            if (Objects.nonNull(entidade)) {
                unico.getEntidades().add(UsuarioEntidade.of((Entidade)entidade).withPrincipal(siscopUsuarioEntidade.getPadrao()));
                continue;
            }
            this.getLog().debug("N\u00e3o foi encontrado entidade do \u00fanico para o usu\u00e1rio legado {}", (Object)legado);
        }
    }

    private void createUnicoGrupos(Usuario unico, SiscopUsuario legado) {
        if (legado.isRoot()) {
            unico.getGrupos().add(Grupo.GRUPO_ADMINISTRADORES);
        }
    }
}

