/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.replicate.siscop;

import br.com.elotech.core.enumerable.common.EnderecoTipo;
import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.core.web.request.ContextHolder;
import br.com.elotech.di.config.UnicoProperties;
import br.com.elotech.di.domain.Bairro;
import br.com.elotech.di.domain.Banco;
import br.com.elotech.di.domain.Cidade;
import br.com.elotech.di.domain.Contato;
import br.com.elotech.di.domain.Endereco;
import br.com.elotech.di.domain.Logradouro;
import br.com.elotech.di.domain.Pessoa;
import br.com.elotech.di.domain.PessoaBanco;
import br.com.elotech.di.domain.PessoaConta;
import br.com.elotech.di.domain.PessoaDocumento;
import br.com.elotech.di.domain.PessoaEndereco;
import br.com.elotech.di.domain.PessoaSituacao;
import br.com.elotech.di.domain.Rg;
import br.com.elotech.di.domain.TipoDocumento;
import br.com.elotech.di.domain.apice.ApicePessoa;
import br.com.elotech.di.domain.siscop.SiscopFornecedor;
import br.com.elotech.di.domain.siscop.SiscopFornecedorBanco;
import br.com.elotech.di.domain.siscop.SiscopFornecedorNegativa;
import br.com.elotech.di.domain.siscop.SiscopTipoDocumento;
import br.com.elotech.di.replicate.siscop.ReplicatorPessoaSiscopAlteracaoRazao;
import br.com.elotech.di.replicate.support.AbstractReplicator;
import br.com.elotech.di.replicate.support.Replicable;
import br.com.elotech.di.replicate.support.ReplicatorFacade;
import br.com.elotech.unico.client.domain.enums.GrauInstrucao;
import br.com.elotech.unico.client.domain.enums.PessoaEscolaridade;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReplicatorPessoaSiscop
extends AbstractReplicator<Pessoa, Long, SiscopFornecedor> {
    private static final int MAX_COMPLEMENTO_SIZE = 100;
    private final ReplicatorPessoaSiscopAlteracaoRazao replicatorAssociationAlteracaoRazao = new ReplicatorPessoaSiscopAlteracaoRazao();
    private final ModelMapper mapper;
    private final UnicoProperties unicoProperties;

    @Autowired
    public ReplicatorPessoaSiscop(ModelMapper mapper, UnicoProperties unicoProperties) {
        this.mapper = mapper;
        this.unicoProperties = unicoProperties;
    }

    public SiscopFornecedor from(Pessoa unico, SiscopFornecedor legado) {
        Contato contato;
        PessoaConta conta;
        this.mapper.map((Object)unico, (Object)legado);
        this.disablePessoa(unico, legado);
        if (unico.getDataAlteracao() != null) {
            legado.setDataAlteracao(unico.getDataAlteracao().toLocalDate());
        }
        legado.setIdUnico(unico.getId());
        if (this.unicoProperties.getIdunico().booleanValue()) {
            legado.setCodigo(unico.getId());
        }
        if (unico.getEscolaridade() != null) {
            legado.setEscolaridade(unico.getEscolaridade().toPessoaEscolaridade());
        }
        if (unico.getRg() != null) {
            legado.setInscestRg(unico.getRg().getNumero());
            legado.setOrgaoemissor(unico.getRg().getOrgaoEmissor());
        } else {
            legado.setInscestRg(unico.getInscricaoEstadual());
        }
        legado.setMescriacao(null);
        if (ContextHolder.hasHeadersValue()) {
            legado.setMescriacao(ContextHolder.getHeaderValueCompetencia());
        }
        if ((conta = unico.getBanco()) != null) {
            if (conta.getAgencia() != null) {
                legado.setAgencia(conta.getAgencia().getCodigo());
                legado.setBanco(this.getReplicatorFacade().getSiscopBanco(conta.getAgencia().getBanco().getId()));
            }
            legado.setConta(conta.getConta());
            legado.setDataaberturaconta(conta.getDataAbertura());
        }
        if ((contato = unico.getContato()) != null) {
            if (contato.getTelefonePrincipal() != null) {
                legado.setTel(contato.getTelefonePrincipal());
            }
            legado.setFax(contato.getTelefoneFax());
            legado.setEmail(contato.getEmail());
            legado.setHomepage(contato.getHomePage());
            legado.setContato(contato.getNome());
        }
        legado.setConsorcio(unico.getConsorcio());
        this.createEnderecoLegado(legado, unico);
        this.createContaBancariaLegado(legado, unico);
        this.createDocumentoLegado(legado, unico);
        this.replicatorAssociationAlteracaoRazao.createAlteracaoRazaoSiscop(unico, legado);
        return legado;
    }

    private void disablePessoa(Pessoa unico, SiscopFornecedor legado) {
        if (BooleanUtils.isTrue((Boolean)unico.getInativo())) {
            legado.setSituacao(PessoaSituacao.INABILITADO_SUSPENSAO);
        }
    }

    private void createDocumentoLegado(SiscopFornecedor legado, Pessoa unico) {
        legado.getDocumentos().clear();
        for (PessoaDocumento documentoPessoa : unico.getDocumentos()) {
            SiscopFornecedorNegativa fornecedorNegativa = new SiscopFornecedorNegativa();
            fornecedorNegativa.setDataEmissao(documentoPessoa.getDoc().getDataEmissao());
            if (documentoPessoa.getDoc().getDocumento() == null) {
                fornecedorNegativa.setTipo(SiscopTipoDocumento.OUTROS);
            } else {
                fornecedorNegativa.setTipo(SiscopTipoDocumento.getToTipoDocumento((TipoDocumento)documentoPessoa.getDoc().getDocumento().getTipoDocumento()));
            }
            fornecedorNegativa.setNumero(documentoPessoa.getDoc().getNumeroDocumento());
            fornecedorNegativa.setValidade(documentoPessoa.getDoc().getDataValidade());
            legado.getDocumentos().add(fornecedorNegativa);
        }
    }

    private void createEnderecoLegado(SiscopFornecedor legado, Pessoa unico) {
        legado.setCep(null);
        legado.setCaixapostal(null);
        legado.setUf(null);
        legado.setCidade(null);
        legado.setCidadeObj(null);
        legado.setEndereco(null);
        legado.setBairro(null);
        Endereco endereco = unico.getEndereco();
        if (endereco != null) {
            if (endereco.getCep() != null) {
                legado.setCep(endereco.getCep().toString());
            }
            if (endereco.getCidade() != null) {
                if (endereco.getCidade().getUf() != null) {
                    legado.setUf(this.getReplicatorFacade().getSiscopUF(endereco.getCidade().getUf().getId()));
                }
                legado.setCidade(String.format("%s", endereco.getCidade().getDescricao()));
                legado.setCidadeObj(this.getReplicatorFacade().getSiscopCidade(endereco.getCidade().getId()));
            }
            if (endereco.getLogradouro() != null) {
                legado.setEndereco(endereco.getLogradouro().getDescricao());
            }
            if (endereco.getBairro() != null) {
                legado.setBairro(endereco.getBairro().getDescricao());
            }
        }
    }

    private void createContaBancariaLegado(SiscopFornecedor legado, Pessoa unico) {
        legado.getBancos().clear();
        List bancos = unico.getBancosPessoa();
        for (PessoaBanco bancoPessoa : bancos) {
            SiscopFornecedorBanco conta = new SiscopFornecedorBanco();
            conta.getPk().setFornecedor(legado);
            conta.getPk().setCodigo(bancoPessoa.getCodigoTCE());
            conta.setConta(bancoPessoa.getConta().getConta());
            conta.setDataAberturaConta(bancoPessoa.getConta().getDataAbertura());
            conta.setDataEncerramento(bancoPessoa.getConta().getDataEncerramento());
            conta.setOperacao(bancoPessoa.getConta().getOperacao());
            if (bancoPessoa.getConta().getAgencia() != null) {
                conta.setAgencia(bancoPessoa.getConta().getAgencia().getCodigo());
                conta.setBanco(this.getReplicatorFacade().getSiscopBanco(bancoPessoa.getConta().getAgencia().getBanco().getId()));
                if (bancoPessoa.getConta().getAgencia().getCidade() != null) {
                    conta.setCidade(this.getReplicatorFacade().getSiscopCidade(bancoPessoa.getConta().getAgencia().getCidade().getId()));
                }
            }
            conta.setPrincipal(bancoPessoa.getConta().getPrincipal());
            conta.setPadraoNovo(bancoPessoa.getPadraoNovo());
            legado.getBancos().add(conta);
        }
    }

    public Pessoa to(SiscopFornecedor legado, Pessoa unico) {
        this.mapper.map((Object)legado, (Object)unico);
        if (legado.getDataAlteracao() != null) {
            unico.setDataAlteracao(LocalDateTime.of(legado.getDataAlteracao(), LocalTime.MIDNIGHT));
        }
        unico.setDataInclusao(legado.getDataCadastro());
        unico.setEscolaridade(GrauInstrucao.toGrauInstrucao((PessoaEscolaridade)legado.getEscolaridade()));
        unico.setFornecedor(Boolean.TRUE);
        unico.setNome(ReplicatorFacade.defaultString((String)legado.getNome(), (int)4));
        unico.setResponsavelliquidacao(legado.getResponsavelliquidacao());
        unico.setIdTcePR(legado.getIdTcePR());
        unico.setAudespEspecial(legado.getAudespEspecial());
        unico.setAudespGenerica(legado.getAudespGenerica());
        unico.setRestricaojudicial(legado.getRestricaojudicial());
        unico.setObservacaoJudicial(legado.getObservacaoJudicial());
        if (!StringUtils.isBlank((String)legado.getInscestRg())) {
            if (legado.getTipoPessoa() == TipoPessoa.FISICA) {
                unico.setRg(new Rg().withNumero(legado.getInscestRg()).withOrgaoEmissor(legado.getOrgaoemissor()));
            } else {
                unico.setInscricaoEstadual(legado.getInscestRg());
            }
        }
        this.createEnderecoUnico(legado, unico);
        this.createContaBancariaUnico(legado, unico);
        this.createDocumentoUnico(legado, unico);
        ReplicatorFacade.checkEnderecoPrincipalIfDontHave((Pessoa)unico);
        ReplicatorFacade.checkContaBancariaPrincipalIfDontHave((Pessoa)unico);
        this.replicatorAssociationAlteracaoRazao.createAlteracaoRazaoUnico(unico, legado);
        unico.setFornecedor(Boolean.TRUE);
        unico.setConsorcio(legado.getConsorcio());
        return unico;
    }

    private void createDocumentoUnico(SiscopFornecedor legado, Pessoa unico) {
        unico.getDocumentos().clear();
        for (SiscopFornecedorNegativa sNegativa : legado.getDocumentos()) {
            PessoaDocumento documentoPessoa = new PessoaDocumento();
            documentoPessoa.getDoc().setDataEmissao(sNegativa.getDataEmissao());
            documentoPessoa.getDoc().setDataValidade(sNegativa.getValidade());
            documentoPessoa.getDoc().setDocumento(this.getReplicatorFacade().findFirstByTipoDocumento(sNegativa.getTipo().getTipoDocumento()));
            documentoPessoa.getDoc().setNumeroDocumento(sNegativa.getNumero());
            documentoPessoa.getDoc().setDataAlteracao(LocalDate.now());
            unico.getDocumentos().add(documentoPessoa);
        }
    }

    private void createContaBancariaUnico(SiscopFornecedor legado, Pessoa unico) {
        unico.getBancosPessoa().clear();
        List contasBancarias = legado.getBancos();
        for (SiscopFornecedorBanco siscopContasBancarias : contasBancarias) {
            if (siscopContasBancarias.getBanco() == null || !StringUtils.isNotBlank((String)siscopContasBancarias.getAgencia())) continue;
            PessoaBanco contaBancaria = new PessoaBanco();
            Banco banco = (Banco)this.getReplicatorFacade().createReAttachEloDomain(Banco.class, (Serializable)siscopContasBancarias.getBanco().getIdUnico());
            contaBancaria.getConta().setAgencia(this.getReplicatorFacade().createOrUpdateAgencia(siscopContasBancarias.getAgencia(), banco, (Replicable)siscopContasBancarias.getCidade()));
            contaBancaria.getConta().setPrincipal(Boolean.valueOf(false));
            contaBancaria.getConta().setDataAbertura(siscopContasBancarias.getDataAberturaConta());
            contaBancaria.getConta().setDataEncerramento(siscopContasBancarias.getDataEncerramento());
            contaBancaria.getConta().setOperacao(siscopContasBancarias.getOperacao());
            contaBancaria.getConta().setConta(siscopContasBancarias.getConta());
            contaBancaria.setCodigoTCE(siscopContasBancarias.getPk().getCodigo());
            contaBancaria.setPadraoNovo(siscopContasBancarias.getPadraoNovo());
            contaBancaria.calculeValidaDigito();
            unico.getBancosPessoa().add(contaBancaria);
        }
    }

    private void createEnderecoUnico(SiscopFornecedor legado, Pessoa unico) {
        unico.getEnderecos().clear();
        if (legado.hasEndereco()) {
            PessoaEndereco endereco = new PessoaEndereco();
            endereco.setPrincipal(Boolean.valueOf(true));
            if (!StringUtils.isBlank((String)legado.getCep())) {
                endereco.getEndereco().setCep(Long.valueOf(NumberUtils.toLong((String)legado.getCep())));
            }
            if (legado.getTipoPessoa() == TipoPessoa.FISICA) {
                endereco.getEndereco().setTipo(EnderecoTipo.RESIDENCIAL);
            } else {
                endereco.getEndereco().setTipo(EnderecoTipo.COMERCIAL);
            }
            String complemento = String.format("%s %s %s", StringUtils.trimToEmpty((String)legado.getEndereco()), StringUtils.trimToEmpty((String)legado.getCidade()), StringUtils.trimToEmpty((String)legado.getBairro()));
            if (complemento != null && complemento.length() > 100) {
                endereco.getEndereco().setComplemento(complemento.substring(0, 100));
            } else {
                endereco.getEndereco().setComplemento(complemento);
            }
            if (legado.getCidadeObj() != null) {
                endereco.getEndereco().setCidade((Cidade)this.getReplicatorFacade().createReAttachEloDomain(Cidade.class, (Serializable)legado.getCidadeObj().getIdUnico()));
            } else {
                endereco.getEndereco().setCidade(this.getReplicatorFacade().createOrGetCidadeInvalida());
            }
            endereco.getEndereco().setLogradouro(this.getReplicatorFacade().createOrGetLogradouroInvalido(Logradouro.LOGRADOURO_INVALIDO.getDescricao(), endereco.getEndereco().getCidade()));
            if (!StringUtils.isBlank((String)legado.getBairro())) {
                endereco.getEndereco().setBairro(this.getReplicatorFacade().createOrGetBairroInvalido(legado.getBairro().toUpperCase(Locale.getDefault()), endereco.getEndereco().getCidade()));
            } else {
                endereco.getEndereco().setBairro(this.getReplicatorFacade().createOrGetBairroInvalido(Bairro.BAIRRO_INVALIDO.getDescricao(), endereco.getEndereco().getCidade()));
            }
            unico.getEnderecos().add(endereco);
        }
    }

    public void mergePessoaApice(Pessoa unico, ApicePessoa apicePessoa) {
        SiscopFornecedor fornecedor = (SiscopFornecedor)this.getReplicatorFacade().find(SiscopFornecedor.class, (Object)apicePessoa.getPessoa());
        if (fornecedor != null) {
            unico.setResponsavelliquidacao(fornecedor.getResponsavelliquidacao());
            unico.setIdTcePR(fornecedor.getIdTcePR());
            unico.setAudespEspecial(fornecedor.getAudespEspecial());
            unico.setAudespGenerica(fornecedor.getAudespGenerica());
            unico.setRestricaojudicial(fornecedor.getRestricaojudicial());
            unico.setObservacaoJudicial(fornecedor.getObservacaoJudicial());
            if (!fornecedor.getBancos().isEmpty()) {
                this.createContaBancariaUnico(fornecedor, unico);
            }
        }
    }
}

