/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.replicate.siscop;

import br.com.elotech.di.domain.Cidade;
import br.com.elotech.di.domain.Logradouro;
import br.com.elotech.di.domain.TipoLogradouro;
import br.com.elotech.di.domain.siscop.SiscopLogradouro;
import br.com.elotech.di.replicate.support.AbstractReplicator;
import br.com.elotech.di.replicate.support.ReplicatorFacade;
import java.io.Serializable;
import org.springframework.stereotype.Component;

@Component
public class ReplicatorLogradouroSiscop
extends AbstractReplicator<Logradouro, Long, SiscopLogradouro> {
    public SiscopLogradouro from(Logradouro unico, SiscopLogradouro legado) {
        legado.setIdUnico(unico.getId());
        legado.setAtivo(Boolean.valueOf(unico.getInativo() == false));
        legado.setDescricao(unico.getDescricao());
        if (unico.getTipoLogradouro() != null) {
            legado.setTipoLogradouro(this.getReplicatorFacade().getSiscopTipoLogradouro(unico.getTipoLogradouro().getId()));
        }
        legado.setCidade(this.getReplicatorFacade().getSiscopCidade(unico.getCidade().getId()));
        return legado;
    }

    public Logradouro to(SiscopLogradouro legado, Logradouro unico) {
        unico.setDescricao(ReplicatorFacade.defaultString((String)legado.getDescricao()));
        unico.setId(legado.getIdUnico());
        unico.setInativo(Boolean.valueOf(legado.getAtivo() == false));
        if (legado.getCidade() == null) {
            unico.setCidade(this.getReplicatorFacade().createOrGetCidadeInvalida());
        } else {
            unico.setCidade((Cidade)this.getReplicatorFacade().createReAttachEloDomain(Cidade.class, (Serializable)legado.getCidade().getIdUnico()));
        }
        if (legado.getTipoLogradouro() != null) {
            unico.setTipoLogradouro((TipoLogradouro)this.getReplicatorFacade().createReAttachEloDomain(TipoLogradouro.class, (Serializable)legado.getTipoLogradouro().getIdUnico()));
        }
        return unico;
    }
}

