/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.replicate.siscop;

import br.com.elotech.di.domain.LeiAto;
import br.com.elotech.di.domain.LeiAtoPublicacao;
import br.com.elotech.di.domain.VeiculoPublicacao;
import br.com.elotech.di.domain.siscop.SiscopLeisAtos;
import br.com.elotech.di.domain.siscop.SiscopOrgaoOficial;
import br.com.elotech.di.replicate.support.BaseAbstractReplicator;
import br.com.elotech.di.replicate.support.ReplicatorAdditionalInfo;
import br.com.elotech.di.utils.EloNumberUtils;
import java.io.Serializable;
import org.springframework.stereotype.Component;

@Component
public class ReplicatorLeiAtoSiscopAdditional
extends BaseAbstractReplicator<LeiAto, Long, SiscopLeisAtos>
implements ReplicatorAdditionalInfo<LeiAto, Long, SiscopLeisAtos> {
    public SiscopLeisAtos from(LeiAto unico, SiscopLeisAtos legado) {
        legado.setOrgaoOficial(null);
        if (unico.getPublicacaoPrincipal() != null) {
            legado.setOrgaoOficial(this.getReplicatorFacade().getSiscopVeiculoPublicacao(unico.getPublicacaoPrincipal().getVeiculoPublicacao()));
        } else if (!unico.getPublicacoes().isEmpty()) {
            legado.setOrgaoOficial(this.getReplicatorFacade().getSiscopVeiculoPublicacao(((LeiAtoPublicacao)unico.getPublicacoes().get(0)).getVeiculoPublicacao()));
        }
        return legado;
    }

    public LeiAto to(SiscopLeisAtos legado, LeiAto unico) {
        SiscopOrgaoOficial orgaoOficial = legado.getOrgaoOficial();
        if (orgaoOficial != null && orgaoOficial.getIdUnico() != null) {
            LeiAtoPublicacao publicacao = new LeiAtoPublicacao();
            publicacao.setNumeroEdicao(EloNumberUtils.toLong((String)legado.getNumeroEdicao()));
            publicacao.setPrincipal(Boolean.valueOf(true));
            publicacao.setDataPublicacao(legado.getDataPublicacao());
            publicacao.setAnoEdicao(legado.getAnoInicio());
            publicacao.setVeiculoPublicacao((VeiculoPublicacao)this.getReplicatorFacade().createReAttachEloDomain(VeiculoPublicacao.class, (Serializable)orgaoOficial.getIdUnico()));
            publicacao.setPagina(legado.getPagina());
            unico.getPublicacoes().add(publicacao);
        }
        return unico;
    }
}

