/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.replicate.siscop;

import br.com.elotech.di.domain.Entidade;
import br.com.elotech.di.domain.LeiAto;
import br.com.elotech.di.domain.LeiAtoArquivo;
import br.com.elotech.di.domain.siscop.SiscopLeisAtos;
import br.com.elotech.di.domain.siscop.SiscopLeisAtosArquivo;
import br.com.elotech.di.replicate.siscop.ReplicatorLeiAtoSiscopAdditional;
import br.com.elotech.di.replicate.support.AbstractReplicator;
import br.com.elotech.di.utils.EloNumberUtils;
import java.io.Serializable;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReplicatorLeiAtoSiscop
extends AbstractReplicator<LeiAto, Long, SiscopLeisAtos> {
    @Autowired
    private ReplicatorLeiAtoSiscopAdditional replicatorLeiAtoSiscopAdditional;

    public void setReplicatorLeiAtoSiscopAdditional(ReplicatorLeiAtoSiscopAdditional replicatorLeiAtoSiscopAdditional) {
        this.replicatorLeiAtoSiscopAdditional = replicatorLeiAtoSiscopAdditional;
    }

    public ReplicatorLeiAtoSiscopAdditional getReplicatorLeiAtoSiscopAdditional() {
        if (this.replicatorLeiAtoSiscopAdditional == null) {
            throw new IllegalStateException("replicator additional null");
        }
        return this.replicatorLeiAtoSiscopAdditional;
    }

    public SiscopLeisAtos from(LeiAto unico, SiscopLeisAtos legado) {
        legado.setEntidade(this.getReplicatorFacade().getSiscopEntidade(unico.getEntidade()));
        legado.setEntidadeOrigem(this.getReplicatorFacade().getSiscopEntidade(unico.getEntidadeOrigem()));
        legado.setEscopo(this.getReplicatorFacade().getSiscopTipoLeiEscopo(unico.getTipoLeiEscopo()));
        legado.setExercicio(unico.getAno());
        legado.setNatureza(this.getReplicatorFacade().getSiscopTipoLeiNatureza(unico.getTipoLeiNatureza()));
        legado.setIdUnico(unico.getId());
        legado.setNumero(unico.getNumero());
        legado.setTipoDocumentoLegal(this.getReplicatorFacade().getSiscopTipoLeiDocumento(unico.getTipoLeiDocumento()));
        legado.setAnoInicio(unico.getAnoInicio());
        legado.setData(unico.getDataAto());
        legado.setDataCadastro(unico.getDataCadastro());
        legado.setDataPublicacao(unico.getDataPublicacao());
        legado.setIdTce(unico.getIdTce());
        legado.setMostrarPortal(unico.getMostraPortal());
        legado.setNumeroEdicao(String.valueOf(unico.getNumeroEdicao()));
        legado.setPagina(unico.getPagina());
        legado.setPercOpCredaro(unico.getPercOpCredaro());
        legado.setPercOpCredInt(unico.getPercOpCredInt());
        legado.setPercSuplementacao(unico.getPercSuplementacao());
        legado.setValorAnulacao(unico.getValorAnulacao());
        legado.setValorEspecial(unico.getValorEspecial());
        legado.setValorExcesso(unico.getValorExcesso());
        legado.setValorExcessoVinculado(unico.getValorExcessoVinculado());
        legado.setValorExtraordinario(unico.getValorExtraordinario());
        legado.setValorOperacaoDeCredito(unico.getValorOperacaoDeCredito());
        legado.setValorSemDespCorrespondente(unico.getValorSemDespCorrespondente());
        legado.setValorSuperavit(unico.getValorSuperavit());
        legado.setValorSuperavitVinculado(unico.getValorSuperavitVinculado());
        legado.setValorSuplementar(unico.getValorSuplementar());
        legado.setSumula(unico.getSumula());
        legado.setMostrarPessoal(unico.getMostraPessoal());
        legado.setMostrarReceita(unico.getMostraReceita());
        legado.setMostrarDespesa(unico.getMostraDespesa());
        this.createLegadoArquivos(unico, legado);
        legado.setLeiAltera(null);
        this.getReplicatorLeiAtoSiscopAdditional().from(unico, legado);
        return legado;
    }

    private void createLegadoArquivos(LeiAto unico, SiscopLeisAtos legado) {
        for (LeiAtoArquivo arquivo : unico.getArquivos()) {
            if (!legado.getArquivos().stream().noneMatch(leg -> leg.hasArquivo() != false && leg.getArquivo().equals((Object)arquivo.getArquivo()))) continue;
            SiscopLeisAtosArquivo arquivoLegado = new SiscopLeisAtosArquivo();
            arquivoLegado.setArquivo(arquivo.getArquivo());
            legado.getArquivos().add(arquivoLegado);
        }
        ArrayList<SiscopLeisAtosArquivo> toRemove = new ArrayList<SiscopLeisAtosArquivo>();
        for (SiscopLeisAtosArquivo siscopLeisAtosArquivo : legado.getArquivos()) {
            if (!unico.getArquivos().stream().noneMatch(uni -> uni.hasArquivo() && uni.getArquivo().equals((Object)siscopLeisAtosArquivo.getArquivo()))) continue;
            toRemove.add(siscopLeisAtosArquivo);
        }
        toRemove.forEach(remove -> legado.getArquivos().remove(remove));
    }

    public LeiAto to(SiscopLeisAtos legado, LeiAto unico) {
        unico.setAno(legado.getExercicio());
        unico.setEntidade((Entidade)this.getReplicatorFacade().createReAttachEloDomain(Entidade.class, (Serializable)legado.getEntidade().getIdUnico()));
        if (legado.getEntidadeOrigem() != null) {
            unico.setEntidadeOrigem((Entidade)this.getReplicatorFacade().createReAttachEloDomain(Entidade.class, (Serializable)legado.getEntidadeOrigem().getIdUnico()));
        }
        unico.setId(legado.getIdUnico());
        unico.setNumero(legado.getNumero());
        unico.setTipoLeiEscopo(this.getReplicatorFacade().getTipoLeiEscopoByCodigo(legado.getEscopo().getCodigo()));
        unico.setTipoLeiNatureza(this.getReplicatorFacade().getTipoLeiNaturezaByCodigo(legado.getNatureza().toTipoLeiNaturezaCodigo()));
        unico.setAnoInicio(legado.getAnoInicio());
        unico.setAnoInicio(legado.getAnoInicio());
        unico.setDataAto(legado.getData());
        unico.setDataCadastro(legado.getDataCadastro());
        unico.setDataPublicacao(legado.getDataPublicacao());
        unico.setIdTce(legado.getIdTce());
        unico.setMostraPortal(legado.getMostrarPortal());
        if (legado.getTipoDocumentoLegal() != null) {
            unico.setTipoLeiDocumento(this.getReplicatorFacade().getTipoLeiDocumentoByCodigo(legado.getTipoDocumentoLegal().getCodigo()));
        }
        if (legado.getNumeroEdicao() != null) {
            unico.setNumeroEdicao(EloNumberUtils.toLong((String)legado.getNumeroEdicao().replaceAll("[^0-9]", "")));
        }
        unico.setPagina(legado.getPagina());
        unico.setPercOpCredaro(legado.getPercOpCredaro());
        unico.setPercOpCredInt(legado.getPercOpCredInt());
        unico.setPercSuplementacao(legado.getPercSuplementacao());
        unico.setValorAnulacao(legado.getValorAnulacao());
        unico.setValorEspecial(legado.getValorEspecial());
        unico.setValorExcesso(legado.getValorExcesso());
        unico.setValorExcessoVinculado(legado.getValorExcessoVinculado());
        unico.setValorExtraordinario(legado.getValorExtraordinario());
        unico.setValorOperacaoDeCredito(legado.getValorOperacaoDeCredito());
        unico.setValorSemDespCorrespondente(legado.getValorSemDespCorrespondente());
        unico.setValorSuperavit(legado.getValorSuperavit());
        unico.setValorSuperavitVinculado(legado.getValorSuperavitVinculado());
        unico.setValorSuplementar(legado.getValorSuplementar());
        unico.setSumula(legado.getSumula());
        unico.setMostraPessoal(legado.getMostrarPessoal());
        unico.setMostraReceita(legado.getMostrarReceita());
        unico.setMostraDespesa(legado.getMostrarDespesa());
        this.createUnicoArquivos(unico, legado);
        this.getReplicatorLeiAtoSiscopAdditional().to(legado, unico);
        return unico;
    }

    private void createUnicoArquivos(LeiAto unico, SiscopLeisAtos legado) {
        for (SiscopLeisAtosArquivo arquivoLegado : legado.getArquivos()) {
            LeiAtoArquivo arquivo = new LeiAtoArquivo();
            arquivo.setArquivo(arquivoLegado.getArquivo());
            unico.getArquivos().add(arquivo);
        }
        if (!unico.getArquivos().isEmpty()) {
            ((LeiAtoArquivo)unico.getArquivos().get(0)).setPrincipal(Boolean.valueOf(true));
        }
    }
}

