/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.replicate.siscop;

import br.com.elotech.core.enumerable.common.EntidadeTipo;
import br.com.elotech.di.domain.Entidade;
import br.com.elotech.di.domain.siscop.SiscopEntidade;
import br.com.elotech.di.domain.support.EloDomain;
import br.com.elotech.di.replicate.support.AbstractReplicator;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.stereotype.Component;

@Component
public class ReplicatorEntidadeSiscop
extends AbstractReplicator<Entidade, Long, SiscopEntidade> {
    public SiscopEntidade from(Entidade unico, SiscopEntidade legado) {
        legado.setIdUnico(unico.getId());
        legado.setNome(unico.getNome());
        legado.setCnpj(unico.getCnpj());
        legado.setBrasao(ArrayUtils.clone((byte[])unico.getBrasao()));
        legado.setCep(unico.getCep());
        legado.setCodAudesp(unico.getCodAudesp());
        legado.setCodMunicAudesp(unico.getCodMunicAudesp());
        legado.setPoderOrgaoContabil(unico.getPoderOrgaoContabil());
        legado.setCodigoSiconfi(unico.getMscCodigoSiconfi());
        if (unico.getCidade() != null) {
            legado.setCidade(unico.getCidade().getDescricao());
            legado.setUf(this.getReplicatorFacade().getSiscopUF(unico.getCidade().getUf().getId()));
        }
        if (unico.getBairro() != null) {
            legado.setBairro(unico.getBairro().getDescricao());
        }
        if (unico.getLogradouro() != null) {
            legado.setLogradouro(unico.getLogradouro().getDescricao() + ", " + unico.getNumero());
        }
        if (unico.isEntidadePrincipal()) {
            legado.setEntidadePrincipal(legado);
        }
        legado.setIdentificacaoTCE(unico.getIdentificacaoTCE());
        legado.setTelefone(unico.getTelefone());
        legado.setTipo(unico.getTipo());
        legado.setClienteElotech(unico.getClienteElotech());
        return legado;
    }

    public Entidade to(SiscopEntidade legado, Entidade unico) {
        unico.setNome(legado.getNome());
        unico.setCnpj(legado.getCnpj());
        unico.setCep(legado.getCep());
        unico.setTelefone(legado.getTelefone());
        unico.setEntidadePrincipal(Boolean.valueOf(legado.isEntidadePrincipal()));
        unico.setIdentificacaoTCE(legado.getIdentificacaoTCE());
        unico.setTipo(EntidadeTipo.orDefault((EntidadeTipo)legado.getTipo()));
        unico.setBrasao(ArrayUtils.clone((byte[])legado.getBrasao()));
        unico.setClienteElotech(legado.getClienteElotech());
        unico.setCodAudesp(legado.getCodAudesp());
        unico.setCodMunicAudesp(legado.getCodMunicAudesp());
        unico.setPoderOrgaoContabil(legado.getPoderOrgaoContabil());
        unico.setMscCodigoSiconfi(legado.getCodigoSiconfi());
        if (unico.getCidade() == null) {
            unico.setCidade(this.getReplicatorFacade().createOrGetCidadeInvalida());
            if (unico.getBairro() == null) {
                unico.setBairro(this.getReplicatorFacade().createOrGetBairroInvalido(legado.getBairro(), unico.getCidade()));
            }
            if (unico.getLogradouro() == null) {
                unico.setLogradouro(this.getReplicatorFacade().createOrGetLogradouroInvalido(legado.getLogradouro(), unico.getCidade()));
            }
        }
        return unico;
    }

    public Entidade merge(Entidade original, Entidade other) {
        if (!original.isEntidadePrincipal() && other.isEntidadePrincipal()) {
            original.setEntidadePrincipal(Boolean.TRUE);
        }
        return (Entidade)super.merge((EloDomain)original, (EloDomain)other);
    }
}

