/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.replicate.siscop;

import br.com.elotech.di.domain.Cidade;
import br.com.elotech.di.domain.UF;
import br.com.elotech.di.domain.siscop.SiscopCidade;
import br.com.elotech.di.replicate.support.AbstractReplicator;
import br.com.elotech.di.replicate.support.CidadeMerger;
import br.com.elotech.di.utils.EloNumberUtils;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReplicatorCidadeSiscop
extends AbstractReplicator<Cidade, Long, SiscopCidade> {
    private final CidadeMerger merger;

    @Autowired
    public ReplicatorCidadeSiscop(CidadeMerger merger) {
        this.merger = merger;
    }

    public SiscopCidade from(Cidade unico, SiscopCidade legado) {
        legado.setCodigoIbge(EloNumberUtils.toString((Long)unico.getCodigoIbge()));
        legado.setDescricao(unico.getDescricao());
        legado.setIdUnico(unico.getId());
        legado.setUnidadeFederacao(this.getReplicatorFacade().getSiscopUF(unico.getUf().getId()));
        legado.setCodigoAplic(unico.getCodigoAplic());
        legado.setAtivo(Boolean.valueOf(unico.getInativo() == false));
        return legado;
    }

    public Cidade to(SiscopCidade legado, Cidade unico) {
        if (StringUtils.isBlank((String)legado.getDescricao())) {
            unico.setDescricao("CONVERSAO");
        } else {
            unico.setDescricao(legado.getDescricao());
        }
        unico.setId(legado.getIdUnico());
        unico.setInativo(Boolean.valueOf(legado.getAtivo() == false));
        unico.setCodigoIbge(EloNumberUtils.toLong((String)legado.getCodigoIbge()));
        unico.setCodigoAplic(legado.getCodigoAplic());
        unico.setUf((UF)this.getReplicatorFacade().createReAttachEloDomain(UF.class, (Serializable)legado.getUnidadeFederacao().getIdUnico()));
        return unico;
    }

    public Cidade merge(Cidade original, Cidade other) {
        return this.merger.merge(original, other);
    }
}

