/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.replicate.protocolo;

import br.com.elotech.core.utils.Cipher;
import br.com.elotech.di.domain.Entidade;
import br.com.elotech.di.domain.Modulo;
import br.com.elotech.di.domain.Usuario;
import br.com.elotech.di.domain.UsuarioEntidade;
import br.com.elotech.di.domain.UsuarioModulo;
import br.com.elotech.di.domain.protocolo.ProtocoloEntidade;
import br.com.elotech.di.domain.protocolo.ProtocoloModulo;
import br.com.elotech.di.domain.protocolo.ProtocoloUsuario;
import br.com.elotech.di.domain.protocolo.ProtocoloUsuarioEntidade;
import br.com.elotech.di.domain.protocolo.ProtocoloUsuarioModulo;
import br.com.elotech.di.replicate.support.AbstractReplicatorUsuario;
import br.com.elotech.di.replicate.support.ReplicateProtocolo;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;

@Component
public class ReplicatorUsuarioProtocolo
extends AbstractReplicatorUsuario<Usuario, Long, ProtocoloUsuario>
implements ReplicateProtocolo {
    private static final String KEY = "UOLNEWS";
    private final PasswordEncoder passwordEncoder;

    @Autowired
    public ReplicatorUsuarioProtocolo(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public ProtocoloUsuario from(Usuario unico, ProtocoloUsuario legado) {
        legado.setAtivo(unico.getAtivo());
        legado.setEmail(unico.getEmail());
        legado.setId(StringUtils.defaultIfBlank((String)legado.getId(), (String)unico.getUsuario()));
        legado.setIdUnico(unico.getId());
        legado.setNome(unico.getNome());
        legado.setCpf(unico.getCpf());
        legado.setSenha(StringUtils.substring((String)unico.getSenha(), (int)0, (int)14));
        legado.setIdKeycloak(unico.getIdKeycloak());
        if (this.getReplicatorFacade().existsUnicoEntidades()) {
            this.createLegadoEntidades(unico, legado);
        }
        this.createLegadoModulos(unico, legado);
        return legado;
    }

    private void createLegadoModulos(Usuario unico, ProtocoloUsuario legado) {
        legado.getModulos().clear();
        List modulos = unico.getModulos();
        for (UsuarioModulo usuarioModulo : modulos) {
            ProtocoloModulo protocoloModulo = this.getReplicatorFacade().getProtocoloModulo(usuarioModulo.getModulo());
            legado.getModulos().add(ProtocoloUsuarioModulo.of((ProtocoloUsuario)legado, (ProtocoloModulo)protocoloModulo));
        }
    }

    private void createLegadoEntidades(Usuario unico, ProtocoloUsuario legado) {
        legado.getEntidades().clear();
        List entidades = unico.getEntidades();
        for (UsuarioEntidade usuarioEntidade : entidades) {
            ProtocoloEntidade protocoloEntidade = this.getReplicatorFacade().getProtocoloEntidade(usuarioEntidade.getEntidade());
            if (Objects.nonNull(protocoloEntidade)) {
                legado.getEntidades().add(ProtocoloUsuarioEntidade.of((ProtocoloUsuario)legado, (ProtocoloEntidade)protocoloEntidade).withPadrao(usuarioEntidade.getPrincipal()));
                continue;
            }
            this.getLog().debug("N\u00e3o foi encontrado entidade do legado para o usu\u00e1rio \u00fanico {}", (Object)unico);
        }
    }

    public Usuario to(ProtocoloUsuario legado, Usuario unico) {
        unico.setEmail(legado.getEmail());
        unico.setId(legado.getIdUnico());
        if (unico.hasToSetUsuario()) {
            unico.setUsuario(legado.getId());
            unico.setUsuarioOriginal(legado.getId());
        }
        unico.setNome(legado.getNome());
        unico.setCpf(legado.getCpf());
        unico.setAtivo(legado.getAtivo());
        this.createUnicoEntidades(unico, legado);
        this.createUnicoModulos(unico, legado);
        if (StringUtils.isBlank((String)unico.getSenha()) && StringUtils.isNotBlank((String)legado.getSenha())) {
            String decodedPwd = Cipher.encrypt((String)legado.getSenha(), (String)KEY);
            unico.setSenha(this.passwordEncoder.encode((CharSequence)decodedPwd));
        }
        return unico;
    }

    private void createUnicoModulos(Usuario unico, ProtocoloUsuario legado) {
        unico.getModulos().clear();
        Set modulos = legado.getModulos();
        for (ProtocoloUsuarioModulo protocoloUsuarioModulo : modulos) {
            Modulo modulo = (Modulo)this.getReplicatorFacade().createReAttachEloDomain(Modulo.class, (Serializable)protocoloUsuarioModulo.getPk().getModulo().getIdUnico());
            unico.getModulos().add(UsuarioModulo.of((Modulo)modulo).withPrincipal(protocoloUsuarioModulo.getPrioritario()));
        }
    }

    private void createUnicoEntidades(Usuario unico, ProtocoloUsuario legado) {
        unico.getEntidades().clear();
        Set entidades = legado.getEntidades();
        for (ProtocoloUsuarioEntidade protocoloUsuarioEntidade : entidades) {
            Entidade entidade = (Entidade)this.getReplicatorFacade().createReAttachEloDomain(Entidade.class, (Serializable)protocoloUsuarioEntidade.getPk().getEntidade().getIdUnico());
            if (Objects.nonNull(entidade)) {
                unico.getEntidades().add(UsuarioEntidade.of((Entidade)entidade).withPrincipal(protocoloUsuarioEntidade.getPadrao()));
                continue;
            }
            this.getLog().debug("N\u00e3o foi encontrado entidade do \u00fanico para o usu\u00e1rio legado {}", (Object)legado);
        }
    }
}

