/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.replicate.protocolo;

import br.com.elotech.di.config.UnicoProperties;
import br.com.elotech.di.domain.Bairro;
import br.com.elotech.di.domain.Cidade;
import br.com.elotech.di.domain.Contato;
import br.com.elotech.di.domain.Logradouro;
import br.com.elotech.di.domain.Pessoa;
import br.com.elotech.di.domain.PessoaEndereco;
import br.com.elotech.di.domain.Rg;
import br.com.elotech.di.domain.protocolo.ProtocoloEnderecoPessoa;
import br.com.elotech.di.domain.protocolo.ProtocoloPessoa;
import br.com.elotech.di.replicate.support.AbstractReplicator;
import br.com.elotech.di.replicate.support.ReplicateProtocolo;
import br.com.elotech.di.replicate.support.ReplicatorFacade;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.stereotype.Component;

@Component
public class ReplicatorPessoaProtocolo
extends AbstractReplicator<Pessoa, Long, ProtocoloPessoa>
implements ReplicateProtocolo {
    private final UnicoProperties unicoProperties;

    public ReplicatorPessoaProtocolo(UnicoProperties unicoProperties) {
        this.unicoProperties = unicoProperties;
    }

    public ProtocoloPessoa from(Pessoa unico, ProtocoloPessoa legado) {
        Contato contato;
        legado.setIdUnico(unico.getId());
        if (unico.getRg() != null) {
            legado.setRg(unico.getRg().getNumero());
        } else {
            legado.setRg(null);
        }
        if (this.unicoProperties.getIdunico().booleanValue()) {
            legado.setPessoa(unico.getId());
        }
        legado.setTipoPessoa(unico.getTipoPessoa());
        legado.setCnpjCpf(unico.getCnpjCpf());
        legado.setNome(unico.getNome());
        legado.setAtivo(Boolean.valueOf(BooleanUtils.isFalse((Boolean)unico.getInativo())));
        if (unico.getDataNascimento() != null) {
            legado.setDataNascimento(unico.getDataNascimento());
        }
        if ((contato = unico.getContato()) != null) {
            if (contato.getTelefonePrincipal() != null) {
                legado.setTelefone(this.getTelefoneFixo(contato));
            }
            legado.setCelular(contato.getTelefoneCelular());
            legado.setEmail(contato.getEmail());
        }
        legado.setEndimovel(null);
        legado.setInscrimovel(null);
        legado.setCargo(null);
        this.createEnderecoProtocolo(unico, legado);
        return legado;
    }

    public String getTelefoneFixo(Contato contato) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)contato.getTelefoneComercial())) {
            return contato.getTelefoneComercial();
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)contato.getTelefoneResidencial())) {
            return contato.getTelefoneResidencial();
        }
        return null;
    }

    private void createEnderecoProtocolo(Pessoa unico, ProtocoloPessoa legado) {
        legado.getEnderecos().clear();
        legado.setEnderecoPrincipal(null);
        List enderecos = unico.getEnderecos();
        long codigoEndereco = 1L;
        for (PessoaEndereco enderecoPessoa : enderecos) {
            ProtocoloEnderecoPessoa endereco = new ProtocoloEnderecoPessoa();
            endereco.getPk().withPessoa(legado);
            endereco.getPk().setCodigo(Long.valueOf(codigoEndereco++));
            endereco.setBairro(null);
            endereco.setCep(null);
            endereco.setCidade(null);
            endereco.setUf(null);
            endereco.setLogradouro(null);
            if (enderecoPessoa.getEndereco().getCidade() != null) {
                endereco.setCidade(this.getReplicatorFacade().getProtocoloCidade(enderecoPessoa.getEndereco().getCidade().getId()));
            }
            if (enderecoPessoa.getEndereco().getBairro() != null) {
                endereco.setBairro(this.getReplicatorFacade().getProtocoloBairro(enderecoPessoa.getEndereco().getBairro().getId()));
            }
            endereco.setCep(null);
            if (enderecoPessoa.getEndereco().getCep() != null) {
                endereco.setCep(Long.toString(enderecoPessoa.getEndereco().getCep()));
            }
            endereco.setComplemento(enderecoPessoa.getEndereco().getComplemento());
            endereco.setUf(null);
            if (enderecoPessoa.getEndereco().getLogradouro() != null) {
                endereco.setLogradouro(this.getReplicatorFacade().getProtocoloLogradouro(enderecoPessoa.getEndereco().getLogradouro().getId()));
            }
            endereco.setNumero(enderecoPessoa.getEndereco().getNumero());
            endereco.setTipoEndereco(enderecoPessoa.getEndereco().getTipo());
            if (enderecoPessoa.getPrincipal().booleanValue()) {
                legado.setEnderecoPrincipal(endereco);
            }
            legado.getEnderecos().add(endereco);
        }
    }

    public Pessoa to(ProtocoloPessoa legado, Pessoa unico) {
        unico.setNome(ReplicatorFacade.defaultString((String)legado.getNome(), (int)4));
        unico.setCnpjCpf(legado.getCnpjCpf());
        unico.setTipoPessoa(legado.getTipoPessoa());
        unico.setInativo(Boolean.valueOf(BooleanUtils.isFalse((Boolean)legado.getAtivo())));
        unico.setDataNascimento(legado.getDataNascimento());
        if (!StringUtils.isBlank((String)legado.getRg())) {
            unico.setRg(new Rg().withNumero(legado.getRg()));
        }
        this.createEnderecoUnico(legado, unico);
        ReplicatorFacade.checkEnderecoPrincipalIfDontHave((Pessoa)unico);
        unico.setProtocolo(Boolean.valueOf(true));
        return unico;
    }

    private void createEnderecoUnico(ProtocoloPessoa legado, Pessoa unico) {
        unico.getEnderecos().clear();
        List enderecos = legado.getEnderecos();
        for (ProtocoloEnderecoPessoa protocoloEndereco : enderecos) {
            PessoaEndereco endereco = new PessoaEndereco();
            endereco.setPrincipal(Boolean.valueOf(false));
            if (legado.getEnderecoPrincipal() != null) {
                endereco.setPrincipal(Boolean.valueOf(legado.getEnderecoPrincipal().equals((Object)protocoloEndereco)));
            }
            if (protocoloEndereco.getCidade() == null || protocoloEndereco.getBairro() == null || protocoloEndereco.getLogradouro() == null) {
                this.getLog().warn("Endere\u00e7o com algum valor nulo.");
                this.adjustInvalidEndereco(endereco);
            } else if (protocoloEndereco.getBairro().getCidade().equals((Object)protocoloEndereco.getCidade()) && protocoloEndereco.getLogradouro().getCidade().equals((Object)protocoloEndereco.getCidade())) {
                endereco.getEndereco().setCidade((Cidade)this.getReplicatorFacade().createReAttachEloDomain(Cidade.class, (Serializable)protocoloEndereco.getCidade().getIdUnico()));
                endereco.getEndereco().setBairro((Bairro)this.getReplicatorFacade().createReAttachEloDomain(Bairro.class, (Serializable)protocoloEndereco.getBairro().getIdUnico()));
                endereco.getEndereco().setLogradouro((Logradouro)this.getReplicatorFacade().createReAttachEloDomain(Logradouro.class, (Serializable)protocoloEndereco.getLogradouro().getIdUnico()));
            } else {
                this.getLog().warn("Endere\u00e7o com cidade diferente do bairro/logradouro.");
                this.adjustInvalidEndereco(endereco);
            }
            endereco.getEndereco().setCep(Long.valueOf(NumberUtils.toLong((String)protocoloEndereco.getCep(), (long)0L)));
            endereco.getEndereco().setComplemento(protocoloEndereco.getComplemento());
            endereco.getEndereco().setNumero(protocoloEndereco.getNumero());
            endereco.getEndereco().setTipo(protocoloEndereco.getTipoEndereco());
            unico.getEnderecos().add(endereco);
        }
    }

    private void adjustInvalidEndereco(PessoaEndereco endereco) {
        endereco.getEndereco().setCidade(this.getReplicatorFacade().createOrGetCidadeInvalida());
        endereco.getEndereco().setBairro(this.getReplicatorFacade().createOrGetBairroInvalido(Bairro.BAIRRO_INVALIDO.getDescricao(), endereco.getEndereco().getCidade()));
        endereco.getEndereco().setLogradouro(this.getReplicatorFacade().createOrGetLogradouroInvalido(Logradouro.LOGRADOURO_INVALIDO.getDescricao(), endereco.getEndereco().getCidade()));
    }
}

