/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.replicate.protocolo;

import br.com.elotech.di.domain.Cidade;
import br.com.elotech.di.domain.Logradouro;
import br.com.elotech.di.domain.TipoLogradouro;
import br.com.elotech.di.domain.protocolo.ProtocoloLogradouro;
import br.com.elotech.di.replicate.support.AbstractReplicator;
import br.com.elotech.di.replicate.support.ReplicateProtocolo;
import br.com.elotech.di.replicate.support.ReplicatorFacade;
import java.io.Serializable;
import org.springframework.stereotype.Component;

@Component
public class ReplicatorLogradouroProtocolo
extends AbstractReplicator<Logradouro, Long, ProtocoloLogradouro>
implements ReplicateProtocolo {
    public ProtocoloLogradouro from(Logradouro unico, ProtocoloLogradouro legado) {
        legado.setIdUnico(unico.getId());
        legado.setDescricao(unico.getDescricao());
        legado.setAtivo(Boolean.valueOf(unico.getInativo() == false));
        if (unico.getTipoLogradouro() == null) {
            legado.setTipoLogradouro(this.getReplicatorFacade().getProtocoloTipoLogradouro(this.getReplicatorFacade().createOrGetTipoLogradouroInvalida().getId()));
        } else {
            legado.setTipoLogradouro(this.getReplicatorFacade().getProtocoloTipoLogradouro(unico.getTipoLogradouro().getId()));
        }
        legado.setCidade(this.getReplicatorFacade().getProtocoloCidade(unico.getCidade().getId()));
        return legado;
    }

    public Logradouro to(ProtocoloLogradouro legado, Logradouro unico) {
        unico.setDescricao(ReplicatorFacade.defaultString((String)legado.getDescricao()));
        unico.setId(legado.getIdUnico());
        unico.setInativo(Boolean.valueOf(legado.getAtivo() == false));
        if (legado.getCidade() == null) {
            unico.setCidade(this.getReplicatorFacade().createOrGetCidadeInvalida());
        } else {
            unico.setCidade((Cidade)this.getReplicatorFacade().createReAttachEloDomain(Cidade.class, (Serializable)legado.getCidade().getIdUnico()));
        }
        if (legado.getTipoLogradouro() != null) {
            unico.setTipoLogradouro((TipoLogradouro)this.getReplicatorFacade().createReAttachEloDomain(TipoLogradouro.class, (Serializable)legado.getTipoLogradouro().getIdUnico()));
        }
        return unico;
    }
}

