/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.replicate.protocolo;

import br.com.elotech.core.enumerable.common.EntidadeTipo;
import br.com.elotech.di.domain.Bairro;
import br.com.elotech.di.domain.Cidade;
import br.com.elotech.di.domain.Entidade;
import br.com.elotech.di.domain.Logradouro;
import br.com.elotech.di.domain.protocolo.ProtocoloEntidade;
import br.com.elotech.di.replicate.support.AbstractReplicator;
import br.com.elotech.di.replicate.support.ReplicateProtocolo;
import java.io.Serializable;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.stereotype.Component;

@Component
public class ReplicatorEntidadeProtocolo
extends AbstractReplicator<Entidade, Long, ProtocoloEntidade>
implements ReplicateProtocolo {
    public ProtocoloEntidade from(Entidade unico, ProtocoloEntidade legado) {
        legado.setIdUnico(unico.getId());
        legado.setNome(unico.getNome());
        legado.setCnpj(unico.getCnpj());
        legado.setBrasao(ArrayUtils.clone((byte[])unico.getBrasao()));
        legado.setCep(unico.getCep());
        legado.setCidade(this.getReplicatorFacade().getProtocoloCidade(unico.getCidade()));
        legado.setBairro(this.getReplicatorFacade().getProtocoloBairro(unico.getBairro()));
        if (unico.isEntidadePrincipal()) {
            legado.setEntidadePrincipal(legado);
        }
        legado.setIdentificacaoTCE(unico.getIdentificacaoTCE());
        legado.setLogradouro(this.getReplicatorFacade().getProtocoloLogradouro(unico.getLogradouro()));
        legado.setNumero(unico.getNumero());
        legado.setTelefone(unico.getTelefone());
        legado.setTipo(unico.getTipo());
        legado.setClienteElotech(unico.getClienteElotech());
        legado.setEntidadeConsole(unico.getEntidadeConsole());
        if (unico.getCidade() != null) {
            legado.setUnidadefederacao(this.getReplicatorFacade().getProtocoloUF(unico.getCidade().getUf().getId()));
        }
        return legado;
    }

    public Entidade to(ProtocoloEntidade legado, Entidade unico) {
        unico.setNome(legado.getNome());
        unico.setCnpj(legado.getCnpj());
        unico.setCep(legado.getCep());
        unico.setNumero(legado.getNumero());
        unico.setTelefone(legado.getTelefone());
        unico.setEntidadePrincipal(legado.isEntidadePrincipal());
        unico.setIdentificacaoTCE(legado.getIdentificacaoTCE());
        unico.setTipo(EntidadeTipo.orDefault((EntidadeTipo)legado.getTipo()));
        unico.setBrasao(ArrayUtils.clone((byte[])legado.getBrasao()));
        unico.setClienteElotech(legado.getClienteElotech());
        if (legado.getCidade() != null) {
            unico.setCidade((Cidade)this.getReplicatorFacade().createReAttachEloDomain(Cidade.class, (Serializable)legado.getCidade().getIdUnico()));
        }
        if (legado.getBairro() != null) {
            unico.setBairro((Bairro)this.getReplicatorFacade().createReAttachEloDomain(Bairro.class, (Serializable)legado.getBairro().getIdUnico()));
        }
        if (legado.getLogradouro() != null) {
            unico.setLogradouro((Logradouro)this.getReplicatorFacade().createReAttachEloDomain(Logradouro.class, (Serializable)legado.getLogradouro().getIdUnico()));
        }
        return unico;
    }
}

