/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.replicate.protocolo;

import br.com.elotech.di.domain.Cidade;
import br.com.elotech.di.domain.UF;
import br.com.elotech.di.domain.protocolo.ProtocoloCidade;
import br.com.elotech.di.replicate.support.AbstractReplicator;
import br.com.elotech.di.replicate.support.CidadeMerger;
import br.com.elotech.di.replicate.support.ReplicateProtocolo;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReplicatorCidadeProtocolo
extends AbstractReplicator<Cidade, Long, ProtocoloCidade>
implements ReplicateProtocolo {
    private final CidadeMerger merger;

    @Autowired
    public ReplicatorCidadeProtocolo(CidadeMerger merger) {
        this.merger = merger;
    }

    public ProtocoloCidade from(Cidade unico, ProtocoloCidade legado) {
        legado.setDescricao(unico.getDescricao());
        legado.setIdUnico(unico.getId());
        legado.setUf(this.getReplicatorFacade().getProtocoloUF(unico.getUf().getId()));
        legado.setAtivo(Boolean.valueOf(unico.getInativo() == false));
        return legado;
    }

    public Cidade to(ProtocoloCidade legado, Cidade unico) {
        if (StringUtils.isBlank((String)legado.getDescricao())) {
            unico.setDescricao("CONVERSAO");
        } else {
            unico.setDescricao(legado.getDescricao());
        }
        unico.setInativo(Boolean.valueOf(legado.getAtivo() == false));
        unico.setId(legado.getIdUnico());
        unico.setUf((UF)this.getReplicatorFacade().createReAttachEloDomain(UF.class, (Serializable)legado.getUf().getIdUnico()));
        return unico;
    }

    public Cidade merge(Cidade original, Cidade other) {
        return this.merger.merge(original, other);
    }
}

