/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.replicate.protocolo;

import br.com.elotech.di.domain.Bairro;
import br.com.elotech.di.domain.Cidade;
import br.com.elotech.di.domain.protocolo.ProtocoloBairro;
import br.com.elotech.di.domain.protocolo.ProtocoloCidade;
import br.com.elotech.di.replicate.support.AbstractReplicator;
import br.com.elotech.di.replicate.support.ReplicateProtocolo;
import br.com.elotech.di.replicate.support.ReplicatorFacade;
import java.io.Serializable;
import org.springframework.stereotype.Component;

@Component
public class ReplicatorBairroProtocolo
extends AbstractReplicator<Bairro, Long, ProtocoloBairro>
implements ReplicateProtocolo {
    public ProtocoloBairro from(Bairro unico, ProtocoloBairro legado) {
        legado.setDescricao(unico.getDescricao());
        legado.setIdUnico(unico.getId());
        legado.setAtivo(Boolean.valueOf(unico.getInativo() == false));
        ProtocoloCidade cidade = this.getReplicatorFacade().getProtocoloCidade(unico.getCidade().getId());
        legado.setCidade(cidade);
        return legado;
    }

    public Bairro to(ProtocoloBairro legado, Bairro unico) {
        unico.setId(legado.getIdUnico());
        unico.setDescricao(ReplicatorFacade.defaultString((String)legado.getDescricao()));
        unico.setInativo(Boolean.valueOf(legado.getAtivo() == false));
        if (legado.getCidade() == null) {
            unico.setCidade(this.getReplicatorFacade().createOrGetCidadeInvalida());
        } else {
            unico.setCidade((Cidade)this.getReplicatorFacade().createReAttachEloDomain(Cidade.class, (Serializable)legado.getCidade().getIdUnico()));
        }
        return unico;
    }
}

