/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.replicate.apice;

import br.com.elotech.di.domain.Pessoa;
import br.com.elotech.di.domain.VeiculoPublicacao;
import br.com.elotech.di.domain.apice.ApiceOrgaoPublicacao;
import br.com.elotech.di.domain.apice.ApiceTipoOrgaoOficial;
import br.com.elotech.di.replicate.support.AbstractReplicatorVeiculoPublicacao;
import br.com.elotech.di.replicate.support.Replicable;
import java.io.Serializable;
import java.util.Objects;
import org.springframework.stereotype.Component;

@Component
public class ReplicatorVeiculoPublicacaoApice
extends AbstractReplicatorVeiculoPublicacao<ApiceOrgaoPublicacao> {
    public VeiculoPublicacao to(ApiceOrgaoPublicacao legado, VeiculoPublicacao unico) {
        super.from(unico, (Replicable)legado);
        unico.setAnoLicitacao(legado.getAnoLicitacao());
        unico.setDataBaixa(legado.getDataBaixa());
        unico.setDataCadastro(legado.getDataCadastro());
        unico.setDescricao(legado.getDescricao());
        unico.setId(legado.getIdUnico());
        unico.setNumeroLicitacao(legado.getNumeroLicitacao());
        unico.setObservacao(legado.getObservacao());
        unico.setCodigoOperacao(VeiculoPublicacao.COD_OPERACAO_INVALIDA);
        if (Objects.isNull(legado.getPessoa())) {
            unico.setPessoa(null);
        } else {
            unico.setPessoa((Pessoa)this.getReplicatorFacade().createReAttachEloDomain(Pessoa.class, (Serializable)legado.getPessoa().getIdUnico()));
        }
        unico.setPossuiLicitacao(legado.getPossuiLicitacao());
        unico.setTipoLicitacao(legado.getTipoLicitacao());
        unico.setEntidade(this.getReplicatorFacade().getEntidadePrincipal());
        return unico;
    }

    public ApiceOrgaoPublicacao from(VeiculoPublicacao unico, ApiceOrgaoPublicacao legado) {
        legado.setAnoLicitacao(unico.getAnoLicitacao());
        if (Objects.isNull(unico.getPessoa())) {
            legado.setPessoa(null);
            legado.setCnpj(null);
        } else {
            legado.setCnpj(unico.getPessoa().getCnpjCpf());
            legado.setPessoa(this.getReplicatorFacade().getApicePessoa(unico.getPessoa().getId()));
        }
        legado.setDataBaixa(unico.getDataBaixa());
        legado.setDataCadastro(unico.getDataCadastro());
        if (Objects.isNull(unico.getLeiAto())) {
            legado.setDataLei(null);
            legado.setDatapublicacaolei(null);
            legado.setNumeroLei(null);
        } else {
            legado.setDataLei(unico.getLeiAto().getDataAto());
            legado.setDatapublicacaolei(unico.getLeiAto().getDataPublicacao());
            legado.setNumeroLei(unico.getLeiAto().getNumero().toString());
        }
        legado.setDescricao(unico.getDescricao());
        legado.setIdUnico(unico.getId());
        legado.setTipoLicitacao(unico.getTipoLicitacao());
        legado.setNumeroLicitacao(unico.getNumeroLicitacao());
        legado.setObservacao(unico.getObservacao());
        legado.setPossuiLicitacao(unico.getPossuiLicitacao());
        legado.setInexistencia(Boolean.valueOf(false));
        legado.setMural(Boolean.valueOf(false));
        legado.setOficial(Boolean.valueOf(false));
        legado.setTipoOrgao(ApiceTipoOrgaoOficial.OFICIAL_PROPRIO);
        return legado;
    }
}

