/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.replicate.apice;

import br.com.elotech.core.utils.Cipher;
import br.com.elotech.di.domain.Entidade;
import br.com.elotech.di.domain.Modulo;
import br.com.elotech.di.domain.Rg;
import br.com.elotech.di.domain.Usuario;
import br.com.elotech.di.domain.UsuarioEntidade;
import br.com.elotech.di.domain.UsuarioModulo;
import br.com.elotech.di.domain.apice.ApiceEntidade;
import br.com.elotech.di.domain.apice.ApiceModulo;
import br.com.elotech.di.domain.apice.ApiceNivelUsuario;
import br.com.elotech.di.domain.apice.ApiceUsuario;
import br.com.elotech.di.domain.apice.ApiceUsuarioEntidade;
import br.com.elotech.di.domain.apice.ApiceUsuarioModulo;
import br.com.elotech.di.replicate.support.AbstractReplicatorUsuario;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;

@Component
public class ReplicatorUsuarioApice
extends AbstractReplicatorUsuario<Usuario, Long, ApiceUsuario> {
    private static final String KEY = "elotechapice";
    private final PasswordEncoder passwordEncoder;

    @Autowired
    public ReplicatorUsuarioApice(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public ApiceUsuario from(Usuario unico, ApiceUsuario legado) {
        legado.setId(StringUtils.defaultIfBlank((String)legado.getId(), (String)unico.getUsuario()));
        legado.setIdUnico(unico.getId());
        legado.setSenha(StringUtils.substring((String)unico.getSenha(), (int)0, (int)14));
        legado.setAtivo(unico.getAtivo());
        legado.setCpf(unico.getCpf());
        legado.setDescricaoCargo(unico.getCargo());
        legado.setMatricula(unico.getMatricula());
        legado.setNome(unico.getNome());
        if (legado.getNivelUsuario() == null) {
            ApiceNivelUsuario apiceNivelUsuario = (ApiceNivelUsuario)this.getReplicatorFacade().find(ApiceNivelUsuario.class, (Object)ApiceNivelUsuario.NIVEL_DEFAULT.getId());
            legado.setNivelUsuario(apiceNivelUsuario);
        }
        if (unico.getRg() != null) {
            legado.setOrgaoEmissor(unico.getRg().getOrgaoEmissor());
            legado.setRg(unico.getRg().getNumero());
        }
        if (this.getReplicatorFacade().existsUnicoEntidades()) {
            this.createLegadoEntidades(unico, legado);
        }
        this.createLegadoModulos(unico, legado);
        return legado;
    }

    private void createLegadoModulos(Usuario unico, ApiceUsuario legado) {
        legado.getModulos().clear();
        List modulos = unico.getModulos();
        for (UsuarioModulo usuarioModulo : modulos) {
            ApiceModulo apiceModulo = this.getReplicatorFacade().getApiceModulo(usuarioModulo.getModulo());
            legado.getModulos().add(ApiceUsuarioModulo.of((ApiceUsuario)legado, (ApiceModulo)apiceModulo));
        }
    }

    private void createLegadoEntidades(Usuario unico, ApiceUsuario legado) {
        legado.getEntidades().clear();
        List entidades = unico.getEntidades();
        for (UsuarioEntidade usuarioEntidade : entidades) {
            ApiceEntidade apiceEntidade = this.getReplicatorFacade().getApiceEntidade(usuarioEntidade.getEntidade());
            if (Objects.nonNull(apiceEntidade)) {
                legado.getEntidades().add(ApiceUsuarioEntidade.of((ApiceUsuario)legado, (ApiceEntidade)apiceEntidade).withPadrao(usuarioEntidade.getPrincipal()));
                continue;
            }
            this.getLog().debug("N\u00e3o foi encontrado entidade do legado para o usu\u00e1rio \u00fanico {}", (Object)unico);
        }
    }

    public Usuario to(ApiceUsuario legado, Usuario unico) {
        unico.setId(legado.getIdUnico());
        unico.setNome(legado.getNome());
        unico.setCpf(legado.getCpf());
        unico.setMatricula(legado.getMatricula());
        unico.setCargo(legado.getDescricaoCargo());
        unico.setRg(new Rg().withNumero(legado.getRg()).withOrgaoEmissor(legado.getOrgaoEmissor()));
        if (unico.hasToSetUsuario()) {
            unico.setUsuario(legado.getId());
            unico.setUsuarioOriginal(legado.getId());
        }
        this.createUnicoEntidades(unico, legado);
        this.createUnicodModulos(unico, legado);
        unico.setAtivo(legado.getAtivo());
        if (StringUtils.isBlank((String)unico.getSenha()) && StringUtils.isNotBlank((String)legado.getSenha())) {
            String decodedPwd = Cipher.encrypt((String)legado.getSenha(), (String)KEY);
            unico.setSenha(this.passwordEncoder.encode((CharSequence)decodedPwd));
        }
        return unico;
    }

    private void createUnicodModulos(Usuario unico, ApiceUsuario legado) {
        unico.getModulos().clear();
        Set modulos = legado.getModulos();
        for (ApiceUsuarioModulo apiceUsuarioModulo : modulos) {
            Modulo modulo = (Modulo)this.getReplicatorFacade().createReAttachEloDomain(Modulo.class, (Serializable)apiceUsuarioModulo.getPk().getModulo().getIdUnico());
            unico.getModulos().add(UsuarioModulo.of((Modulo)modulo).withPrincipal(apiceUsuarioModulo.getPrioritario()));
        }
    }

    private void createUnicoEntidades(Usuario unico, ApiceUsuario legado) {
        unico.getEntidades().clear();
        Set entidades = legado.getEntidades();
        for (ApiceUsuarioEntidade apiceUsuarioEntidade : entidades) {
            Entidade entidade = (Entidade)this.getReplicatorFacade().createReAttachEloDomain(Entidade.class, (Serializable)apiceUsuarioEntidade.getPk().getEntidade().getIdUnico());
            if (Objects.nonNull(entidade)) {
                unico.getEntidades().add(UsuarioEntidade.of((Entidade)entidade).withPrincipal(apiceUsuarioEntidade.getPadrao()));
                continue;
            }
            this.getLog().debug("N\u00e3o foi encontrado entidade do \u00fanico para o usu\u00e1rio legado {}", (Object)legado);
        }
    }
}

