/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.replicate.apice;

import br.com.elotech.di.domain.Bairro;
import br.com.elotech.di.domain.Banco;
import br.com.elotech.di.domain.Cidade;
import br.com.elotech.di.domain.Logradouro;
import br.com.elotech.di.domain.Pessoa;
import br.com.elotech.di.domain.PessoaBanco;
import br.com.elotech.di.domain.PessoaContato;
import br.com.elotech.di.domain.PessoaDocumento;
import br.com.elotech.di.domain.PessoaEndereco;
import br.com.elotech.di.domain.PessoaSocio;
import br.com.elotech.di.domain.RamoAtividade;
import br.com.elotech.di.domain.apice.ApiceArquivo;
import br.com.elotech.di.domain.apice.ApiceBancoPessoa;
import br.com.elotech.di.domain.apice.ApiceContatoPessoa;
import br.com.elotech.di.domain.apice.ApiceEnderecoPessoa;
import br.com.elotech.di.domain.apice.ApicePessoa;
import br.com.elotech.di.domain.apice.ApicePessoaDocumentacao;
import br.com.elotech.di.domain.apice.ApicePessoaSocio;
import br.com.elotech.di.domain.apice.ApiceRamoAtividade;
import br.com.elotech.di.replicate.support.Replicable;
import br.com.elotech.di.replicate.support.ReplicatorFacade;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityNotFoundException;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.security.core.context.SecurityContextHolder;

public class ReplicatorPessoaApiceAssociations {
    @Generated
    private static final Logger log = Logger.getLogger(ReplicatorPessoaApiceAssociations.class.getName());
    private final ReplicatorFacade replicatorFacade;

    public ReplicatorPessoaApiceAssociations(ReplicatorFacade replicatorFacade) {
        this.replicatorFacade = replicatorFacade;
    }

    private ReplicatorFacade getReplicatorFacade() {
        return this.replicatorFacade;
    }

    public void createRamosApice(Pessoa unico, ApicePessoa legado) {
        legado.getRamoAtividades().clear();
        for (RamoAtividade ramoAtividade : unico.getRamoAtividades()) {
            legado.getRamoAtividades().add(this.getReplicatorFacade().getApiceRamoAtividade(ramoAtividade.getId()));
        }
    }

    public void createEnderecoApice(Pessoa unico, ApicePessoa legado) {
        legado.getEnderecos().clear();
        legado.setEnderecoPrincipal(null);
        List enderecos = unico.getEnderecos();
        long codigoEndereco = 1L;
        for (PessoaEndereco enderecoPessoa : enderecos) {
            ApiceEnderecoPessoa endereco = new ApiceEnderecoPessoa();
            endereco.getPk().withPessoa(legado);
            endereco.getPk().setCodigo(Long.valueOf(codigoEndereco++));
            endereco.setBairro(null);
            endereco.setCep(null);
            endereco.setCidade(null);
            endereco.setEstado(null);
            endereco.setLogradouro(null);
            if (enderecoPessoa.getEndereco().getCidade() != null) {
                endereco.setCidade(this.getReplicatorFacade().getApiceCidade(enderecoPessoa.getEndereco().getCidade().getId()));
                if (enderecoPessoa.getEndereco().getCidade().getUf() != null) {
                    endereco.setEstado(enderecoPessoa.getEndereco().getCidade().getUf().getSigla());
                }
            }
            if (enderecoPessoa.getEndereco().getBairro() != null) {
                endereco.setBairro(this.getReplicatorFacade().getApiceBairro(enderecoPessoa.getEndereco().getBairro().getId()));
            }
            if (enderecoPessoa.getEndereco().getCep() != null) {
                endereco.setCep(Long.toString(enderecoPessoa.getEndereco().getCep()));
            }
            endereco.setComplemento(enderecoPessoa.getEndereco().getComplemento());
            if (enderecoPessoa.getEndereco().getLogradouro() != null) {
                endereco.setLogradouro(this.getReplicatorFacade().getApiceLogradouro(enderecoPessoa.getEndereco().getLogradouro().getId()));
            }
            endereco.setNumero(enderecoPessoa.getEndereco().getNumero());
            endereco.setTipoEndereco(enderecoPessoa.getEndereco().getTipo());
            if (enderecoPessoa.getPrincipal().booleanValue()) {
                legado.setEnderecoPrincipal(endereco);
            }
            legado.getEnderecos().add(endereco);
        }
    }

    public void createContatoApice(Pessoa unico, ApicePessoa legado) {
        legado.getContatos().clear();
        legado.setContatoPrincipal(null);
        List contatos = unico.getContatos();
        Long codigoContato = 1L;
        for (PessoaContato contatoPessoa : contatos) {
            ApiceContatoPessoa contato = new ApiceContatoPessoa();
            contato.getPk().setPessoa(legado);
            Long l = codigoContato;
            codigoContato = codigoContato + 1L;
            contato.getPk().setCodigo(l);
            contato.setEmail(contatoPessoa.getContato().getEmail());
            contato.setNome(contatoPessoa.getContato().getNome());
            contato.setRepresentanteLegal(contatoPessoa.getContato().getRepresentanteLegal());
            contato.setHomePage(contatoPessoa.getContato().getHomePage());
            contato.setTelefoneCelular(contatoPessoa.getContato().getTelefoneCelular());
            contato.setTelefoneComercial(contatoPessoa.getContato().getTelefoneComercial());
            contato.setTelefoneFax(contatoPessoa.getContato().getTelefoneFax());
            contato.setTelefoneResidencial(contatoPessoa.getContato().getTelefoneResidencial());
            contato.setRg(contatoPessoa.getContato().getRg());
            contato.setRepresentante(contatoPessoa.getContato().getRepresentante());
            contato.setBrasileiro(contatoPessoa.getContato().getBrasileiro());
            contato.setOrgaoEmissor(contatoPessoa.getContato().getOrgaoEmissor());
            contato.setDataJuntaComercial(contatoPessoa.getContato().getDataJuntaComercial());
            contato.setCpf(contatoPessoa.getContato().getCpf());
            if (contatoPessoa.getPrincipal().booleanValue()) {
                legado.setContatoPrincipal(contato);
            }
            legado.getContatos().add(contato);
        }
    }

    public void createContaBancariaApice(Pessoa unico, ApicePessoa legado) {
        legado.getBancos().clear();
        legado.setContaBancariaPrincipal(null);
        List bancosPessoa = unico.getBancosPessoa();
        long codigoContaBancaria = 1L;
        for (PessoaBanco bancoPessoa : bancosPessoa) {
            ApiceBancoPessoa conta = new ApiceBancoPessoa();
            conta.getPk().setPessoa(legado);
            conta.getPk().setCodigo(Long.valueOf(codigoContaBancaria++));
            if (bancoPessoa.getConta().getAgencia() != null) {
                conta.getPk().setBanco(this.getReplicatorFacade().getApiceBanco(bancoPessoa.getConta().getAgencia().getBanco().getId()));
                conta.setAgencia(bancoPessoa.getConta().getAgencia().getCodigo());
                if (bancoPessoa.getConta().getAgencia().getCidade() != null) {
                    conta.setCidade(this.getReplicatorFacade().getApiceCidade(bancoPessoa.getConta().getAgencia().getCidade().getId()));
                }
            }
            conta.setConta(bancoPessoa.getConta().getConta());
            conta.setDataAbertura(bancoPessoa.getConta().getDataAbertura());
            conta.setDataEncerramento(bancoPessoa.getConta().getDataEncerramento());
            conta.setOperacao(bancoPessoa.getConta().getOperacao());
            if (bancoPessoa.getConta().getPrincipal().booleanValue()) {
                legado.setContaBancariaPrincipal(conta);
            }
            legado.getBancos().add(conta);
        }
    }

    public void createRamosUnico(Pessoa unico, ApicePessoa legado) {
        unico.getRamoAtividades().clear();
        for (ApiceRamoAtividade apiceRamoAtividade : legado.getRamoAtividades()) {
            unico.getRamoAtividades().add((RamoAtividade)this.getReplicatorFacade().createReAttachEloDomain(RamoAtividade.class, (Serializable)apiceRamoAtividade.getIdUnico()));
        }
    }

    public void createContaBancariaUnico(ApicePessoa legado, Pessoa unico) {
        unico.getBancosPessoa().clear();
        List contasBancarias = legado.getBancos();
        for (ApiceBancoPessoa apiceContasBancarias : contasBancarias) {
            if (apiceContasBancarias.getPk().getBanco() == null || !StringUtils.isNotBlank((String)apiceContasBancarias.getAgencia())) continue;
            PessoaBanco contaBancaria = new PessoaBanco();
            Banco banco = (Banco)this.getReplicatorFacade().createReAttachEloDomain(Banco.class, (Serializable)apiceContasBancarias.getPk().getBanco().getIdUnico());
            contaBancaria.getConta().setAgencia(this.getReplicatorFacade().createOrUpdateAgencia(apiceContasBancarias.getAgencia(), banco, (Replicable)apiceContasBancarias.getCidade()));
            contaBancaria.getConta().setPrincipal(Boolean.valueOf(false));
            contaBancaria.getConta().setDataAbertura(apiceContasBancarias.getDataAbertura());
            contaBancaria.getConta().setDataEncerramento(apiceContasBancarias.getDataEncerramento());
            contaBancaria.getConta().setOperacao(apiceContasBancarias.getOperacao());
            contaBancaria.getConta().setConta(apiceContasBancarias.getConta());
            if (legado.getContaBancariaPrincipal() != null) {
                contaBancaria.getConta().setPrincipal(Boolean.valueOf(legado.getContaBancariaPrincipal().equals((Object)apiceContasBancarias)));
            }
            contaBancaria.calculeValidaDigito();
            unico.getBancosPessoa().add(contaBancaria);
        }
    }

    public void createContatoUnico(ApicePessoa legado, Pessoa unico) {
        unico.getContatos().clear();
        List contatos = legado.getContatos();
        for (ApiceContatoPessoa apiceContato : contatos) {
            PessoaContato contato = new PessoaContato();
            contato.setPrincipal(Boolean.valueOf(false));
            contato.getContato().setNome(StringUtils.defaultIfBlank((String)apiceContato.getNome(), (String)legado.getNome()));
            contato.getContato().setEmail(apiceContato.getEmail());
            contato.getContato().setRepresentanteLegal(apiceContato.getRepresentanteLegal());
            contato.getContato().setHomePage(apiceContato.getHomePage());
            contato.getContato().setTelefoneCelular(apiceContato.getTelefoneCelular());
            contato.getContato().setTelefoneComercial(apiceContato.getTelefoneComercial());
            contato.getContato().setTelefoneFax(apiceContato.getTelefoneFax());
            contato.getContato().setTelefoneResidencial(apiceContato.getTelefoneResidencial());
            contato.getContato().setRg(apiceContato.getRg());
            contato.getContato().setRepresentante(apiceContato.getRepresentante());
            contato.getContato().setBrasileiro(apiceContato.getBrasileiro());
            contato.getContato().setOrgaoEmissor(apiceContato.getOrgaoEmissor());
            contato.getContato().setDataJuntaComercial(apiceContato.getDataJuntaComercial());
            contato.getContato().setCpf(apiceContato.getCpf());
            if (legado.getContatoPrincipal() != null) {
                contato.setPrincipal(Boolean.valueOf(legado.getContatoPrincipal().equals((Object)apiceContato)));
            }
            unico.getContatos().add(contato);
        }
        this.createContatoWithPessoaApice(legado, unico);
    }

    private void createContatoWithPessoaApice(ApicePessoa legado, Pessoa unico) {
        if (legado.getEmail() != null || legado.getFoneComercial() != null || legado.getFoneFax() != null || legado.getHomepage() != null) {
            PessoaContato contatoPessoa = new PessoaContato();
            contatoPessoa.setPrincipal(Boolean.valueOf(false));
            contatoPessoa.getContato().setNome(legado.getNome());
            contatoPessoa.getContato().setEmail(legado.getEmail());
            contatoPessoa.getContato().setHomePage(legado.getHomepage());
            contatoPessoa.getContato().setTelefoneComercial(legado.getFoneComercial());
            contatoPessoa.getContato().setTelefoneFax(legado.getFoneFax());
            unico.getContatos().add(contatoPessoa);
        }
    }

    public void createEnderecoUnico(ApicePessoa legado, Pessoa unico) {
        unico.getEnderecos().clear();
        List enderecos = legado.getEnderecos();
        for (ApiceEnderecoPessoa apiceEndereco : enderecos) {
            PessoaEndereco endereco = new PessoaEndereco();
            endereco.setPrincipal(Boolean.valueOf(false));
            if (legado.getEnderecoPrincipal() != null) {
                endereco.setPrincipal(Boolean.valueOf(legado.getEnderecoPrincipal().equals((Object)apiceEndereco)));
            }
            endereco.getEndereco().setBairro(null);
            endereco.getEndereco().setCidade(null);
            endereco.getEndereco().setLogradouro(null);
            if (apiceEndereco.getBairro() != null) {
                endereco.getEndereco().setBairro((Bairro)this.getReplicatorFacade().createReAttachEloDomain(Bairro.class, (Serializable)apiceEndereco.getBairro().getIdUnico()));
            }
            if (apiceEndereco.getCidade() != null) {
                endereco.getEndereco().setCidade((Cidade)this.getReplicatorFacade().createReAttachEloDomain(Cidade.class, (Serializable)apiceEndereco.getCidade().getIdUnico()));
            }
            if (apiceEndereco.getLogradouro() != null) {
                endereco.getEndereco().setLogradouro((Logradouro)this.getReplicatorFacade().createReAttachEloDomain(Logradouro.class, (Serializable)apiceEndereco.getLogradouro().getIdUnico()));
            }
            endereco.getEndereco().setCep(Long.valueOf(NumberUtils.toLong((String)apiceEndereco.getCep(), (long)0L)));
            endereco.getEndereco().setComplemento(apiceEndereco.getComplemento());
            endereco.getEndereco().setNumero(apiceEndereco.getNumero());
            endereco.getEndereco().setTipo(apiceEndereco.getTipoEndereco());
            unico.getEnderecos().add(endereco);
        }
    }

    public void createSociosUnico(Pessoa unico, ApicePessoa legado) {
        unico.getSocios().clear();
        for (ApicePessoaSocio apicePessoaSocio : legado.getSocios()) {
            if (apicePessoaSocio.getPessoaSocio() == null || apicePessoaSocio.getPessoaSocio().getIdUnico() == null) continue;
            PessoaSocio socioPessoa = new PessoaSocio();
            socioPessoa.getSocio().setSocio((Pessoa)this.getReplicatorFacade().createReAttachEloDomain(Pessoa.class, (Serializable)apicePessoaSocio.getPessoaSocio().getIdUnico()));
            socioPessoa.getSocio().setDataRegistro(apicePessoaSocio.getDataRegistro());
            socioPessoa.getSocio().setFuncao(apicePessoaSocio.getFuncao());
            socioPessoa.getSocio().setNumeroRegistro(apicePessoaSocio.getNumeroRegistro());
            socioPessoa.getSocio().setTipoRegistro(apicePessoaSocio.getTipoRegistro());
            unico.getSocios().add(socioPessoa);
        }
    }

    public void createSociosApice(Pessoa unico, ApicePessoa legado) {
        legado.getSocios().clear();
        for (PessoaSocio socioPessoa : unico.getSocios()) {
            try {
                ApicePessoaSocio apicePessoaSocio = new ApicePessoaSocio();
                apicePessoaSocio.getPk().setPessoa(legado);
                apicePessoaSocio.setPessoaSocio(this.getReplicatorFacade().getApicePessoa(socioPessoa.getSocio().getSocio().getId()));
                apicePessoaSocio.setDataRegistro(socioPessoa.getSocio().getDataRegistro());
                apicePessoaSocio.setFuncao(socioPessoa.getSocio().getFuncao());
                apicePessoaSocio.setNumeroRegistro(socioPessoa.getSocio().getNumeroRegistro());
                apicePessoaSocio.setTipoRegistro(socioPessoa.getSocio().getTipoRegistro());
                legado.getSocios().add(apicePessoaSocio);
            }
            catch (EntityNotFoundException e) {
                log.log(Level.SEVERE, "Not found socio " + String.valueOf(socioPessoa), e);
            }
        }
    }

    public void createDocumentosApice(Pessoa unico, ApicePessoa legado) {
        legado.getDocumentos().clear();
        for (PessoaDocumento documentoPessoa : unico.getDocumentos()) {
            ApicePessoaDocumentacao apiceDocumentacao = new ApicePessoaDocumentacao();
            apiceDocumentacao.setDataEmissaoDocumento(documentoPessoa.getDoc().getDataEmissao());
            apiceDocumentacao.setDocumentacao(null);
            if (documentoPessoa.getDoc().getDocumento() != null) {
                apiceDocumentacao.setDocumentacao(this.getReplicatorFacade().getApiceDocumentacao(documentoPessoa.getDoc().getDocumento().getId()));
            }
            apiceDocumentacao.setDataInclusao(documentoPessoa.getDoc().getDataAlteracao());
            apiceDocumentacao.setNumeroDocumento(documentoPessoa.getDoc().getNumeroDocumento());
            apiceDocumentacao.setValidadeDocumento(documentoPessoa.getDoc().getDataValidade());
            if (Objects.nonNull(documentoPessoa.getDoc().getArquivo())) {
                ApiceArquivo apiceArquivo = new ApiceArquivo();
                apiceArquivo.setArquivo(documentoPessoa.getDoc().getArquivo());
                apiceDocumentacao.setArquivo(apiceArquivo);
                if (Objects.nonNull(SecurityContextHolder.getContext()) && Objects.nonNull(SecurityContextHolder.getContext().getAuthentication())) {
                    apiceArquivo.setUsuario(SecurityContextHolder.getContext().getAuthentication().getName());
                }
            }
            legado.getDocumentos().add(apiceDocumentacao);
        }
    }

    public void createDocumentosUnico(Pessoa unico, ApicePessoa legado) {
        unico.getDocumentos().clear();
        for (ApicePessoaDocumentacao apiceDocumentacao : legado.getDocumentos()) {
            PessoaDocumento documentoPessoa = new PessoaDocumento();
            documentoPessoa.getDoc().setDataAlteracao(apiceDocumentacao.getDataInclusao());
            documentoPessoa.getDoc().setDataEmissao(apiceDocumentacao.getDataEmissaoDocumento());
            documentoPessoa.getDoc().setDataValidade(apiceDocumentacao.getValidadeDocumento());
            documentoPessoa.getDoc().setDocumento(this.getReplicatorFacade().getDocumentoById(apiceDocumentacao.getDocumentacao().getIdUnico()));
            documentoPessoa.getDoc().setNumeroDocumento(apiceDocumentacao.getNumeroDocumento());
            documentoPessoa.getDoc().setArquivo(apiceDocumentacao.getArquivo());
            unico.getDocumentos().add(documentoPessoa);
        }
    }
}

