/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.replicate.apice;

import br.com.elotech.core.web.request.ContextHolder;
import br.com.elotech.di.config.UnicoProperties;
import br.com.elotech.di.domain.Cnae;
import br.com.elotech.di.domain.Contato;
import br.com.elotech.di.domain.Pessoa;
import br.com.elotech.di.domain.PessoaConta;
import br.com.elotech.di.domain.PessoaSituacao;
import br.com.elotech.di.domain.Rg;
import br.com.elotech.di.domain.UF;
import br.com.elotech.di.domain.apice.ApicePessoa;
import br.com.elotech.di.replicate.apice.ReplicatorPessoaApiceAlteracaoRazao;
import br.com.elotech.di.replicate.apice.ReplicatorPessoaApiceAssociations;
import br.com.elotech.di.replicate.siscop.ReplicatorPessoaSiscop;
import br.com.elotech.di.replicate.support.AbstractReplicator;
import br.com.elotech.di.replicate.support.ReplicatorFacade;
import br.com.elotech.unico.client.domain.enums.GrauInstrucao;
import br.com.elotech.unico.client.domain.enums.PessoaEscolaridade;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.modelmapper.ModelMapper;
import org.modelmapper.PropertyMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReplicatorPessoaApice
extends AbstractReplicator<Pessoa, Long, ApicePessoa> {
    private final ModelMapper modelMapper;
    private final ReplicatorPessoaApiceAssociations replicatorAssociations;
    private final ReplicatorPessoaApiceAlteracaoRazao replicatorAssociationAlteracaoRazao = new ReplicatorPessoaApiceAlteracaoRazao();
    private final ReplicatorPessoaSiscop replicatorPessoaSiscop;
    private final UnicoProperties unicoProperties;

    @Autowired
    public ReplicatorPessoaApice(ReplicatorFacade replicatorFacade, ModelMapper modelMapper, ReplicatorPessoaSiscop replicatorPessoaSiscop, UnicoProperties unicoProperties) {
        this.modelMapper = modelMapper;
        this.modelMapper.addMappings((PropertyMap)new /* Unavailable Anonymous Inner Class!! */);
        this.replicatorPessoaSiscop = replicatorPessoaSiscop;
        this.replicatorAssociations = new ReplicatorPessoaApiceAssociations(replicatorFacade);
        this.unicoProperties = unicoProperties;
    }

    public ApicePessoa from(Pessoa unico, ApicePessoa legado) {
        PessoaConta conta;
        this.modelMapper.map((Object)unico, (Object)legado);
        this.disablePessoa(unico, legado);
        if (unico.getDataAlteracao() != null) {
            legado.setDataAlteracao(unico.getDataAlteracao().toLocalDate());
        }
        legado.setIdUnico(unico.getId());
        if (this.unicoProperties.getIdunico().booleanValue()) {
            legado.setPessoa(unico.getId());
        }
        if (unico.getEscolaridade() != null) {
            legado.setEscolaridade(unico.getEscolaridade().toPessoaEscolaridade());
        }
        if (unico.getRg() != null) {
            legado.setDataEmissao(unico.getRg().getDataEmissao());
            legado.setRg(unico.getRg().getNumero());
            legado.setOrgaoEmissor(unico.getRg().getOrgaoEmissor());
            if (unico.getRg().getUf() != null) {
                legado.setEstadoEmissor(this.getReplicatorFacade().getApiceUF(unico.getRg().getUf().getId()));
            }
        } else {
            legado.setDataEmissao(null);
            legado.setRg(null);
            legado.setOrgaoEmissor(null);
            legado.setEstadoEmissor(null);
        }
        legado.setCnae(null);
        legado.setConsorcio(unico.getConsorcio());
        if (unico.getCnae() != null) {
            legado.setCnae(this.getReplicatorFacade().getApiceCnae(unico.getCnae().getId()));
        }
        legado.setUsuario(this.getReplicatorFacade().getUsuario());
        if (ContextHolder.hasHeadersValue() && ContextHolder.getHeaderValueModulo() != null) {
            legado.setModulo(Integer.getInteger(ContextHolder.getHeaderValueModulo().getValue()));
        }
        if ((conta = unico.getBanco()) != null) {
            if (conta.getAgencia() != null) {
                legado.setAgencia(conta.getAgencia().getCodigo());
                legado.setBanco(conta.getAgencia().getBanco().getCodigo());
            }
            legado.setConta(conta.getConta());
        }
        this.createContato(unico, legado);
        this.replicatorAssociations.createEnderecoApice(unico, legado);
        this.replicatorAssociations.createContatoApice(unico, legado);
        this.replicatorAssociations.createContaBancariaApice(unico, legado);
        this.replicatorAssociations.createRamosApice(unico, legado);
        this.replicatorAssociationAlteracaoRazao.createAlteracaoRazaoApice(unico, legado);
        this.replicatorAssociations.createSociosApice(unico, legado);
        this.replicatorAssociations.createDocumentosApice(unico, legado);
        return legado;
    }

    private void disablePessoa(Pessoa unico, ApicePessoa legado) {
        if (BooleanUtils.isTrue((Boolean)unico.getInativo())) {
            legado.setSituacao(PessoaSituacao.INABILITADO);
        }
    }

    private void createContato(Pessoa unico, ApicePessoa legado) {
        Contato contato = unico.getContato();
        if (contato != null) {
            legado.setFoneComercial(contato.getTelefoneComercial());
            legado.setEmail(contato.getEmail());
            legado.setFoneFax(contato.getTelefoneFax());
            legado.setHomepage(contato.getHomePage());
        }
    }

    public Pessoa to(ApicePessoa legado, Pessoa unico) {
        this.modelMapper.map((Object)legado, (Object)unico);
        if (legado.getDataAlteracao() != null) {
            unico.setDataAlteracao(LocalDateTime.of(legado.getDataAlteracao(), LocalTime.MIDNIGHT));
        }
        unico.setNome(ReplicatorFacade.defaultString((String)legado.getNome(), (int)4));
        unico.setEscolaridade(GrauInstrucao.toGrauInstrucao((PessoaEscolaridade)legado.getEscolaridade()));
        unico.setConsorcio(legado.getConsorcio());
        if (!StringUtils.isBlank((String)legado.getRg())) {
            UF uf = null;
            if (legado.getEstadoEmissor() != null) {
                uf = (UF)this.getReplicatorFacade().createReAttachEloDomain(UF.class, (Serializable)legado.getEstadoEmissor().getIdUnico());
            }
            unico.setRg(new Rg().withDataEmissao(legado.getDataEmissao()).withNumero(legado.getRg()).withOrgaoEmissor(legado.getOrgaoEmissor()).withUf(uf));
        }
        this.replicatorAssociations.createContaBancariaUnico(legado, unico);
        this.replicatorAssociations.createContatoUnico(legado, unico);
        this.replicatorAssociations.createEnderecoUnico(legado, unico);
        this.replicatorAssociations.createRamosUnico(unico, legado);
        this.replicatorAssociationAlteracaoRazao.createAlteracaoRazaoUnico(unico, legado);
        this.replicatorAssociations.createSociosUnico(unico, legado);
        this.replicatorAssociations.createDocumentosUnico(unico, legado);
        ReplicatorFacade.checkEnderecoPrincipalIfDontHave((Pessoa)unico);
        ReplicatorFacade.checkContatoPrincipalIfDontHave((Pessoa)unico);
        ReplicatorFacade.checkContaBancariaPrincipalIfDontHave((Pessoa)unico);
        if (legado.getCnae() != null) {
            unico.setCnae((Cnae)this.getReplicatorFacade().createReAttachEloDomain(Cnae.class, (Serializable)legado.getCnae().getIdUnico()));
        } else {
            unico.setCnae(null);
        }
        this.replicatorPessoaSiscop.mergePessoaApice(unico, legado);
        return unico;
    }
}

