/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.replicate.apice;

import br.com.elotech.di.domain.Cidade;
import br.com.elotech.di.domain.Logradouro;
import br.com.elotech.di.domain.TipoLogradouro;
import br.com.elotech.di.domain.apice.ApiceCidade;
import br.com.elotech.di.domain.apice.ApiceLogradouro;
import br.com.elotech.di.domain.apice.ApiceLogradouroPK;
import br.com.elotech.di.exception.UnableToChangePKException;
import br.com.elotech.di.replicate.support.AbstractReplicator;
import br.com.elotech.di.replicate.support.ReplicatorFacade;
import java.io.Serializable;
import org.springframework.stereotype.Component;

@Component
public class ReplicatorLogradouroApice
extends AbstractReplicator<Logradouro, Long, ApiceLogradouro> {
    public ApiceLogradouro from(Logradouro unico, ApiceLogradouro legado) {
        legado.setIdUnico(unico.getId());
        legado.setDescricao(unico.getDescricao());
        legado.setAtivo(Boolean.valueOf(unico.getInativo() == false));
        if (unico.getTipoLogradouro() != null) {
            legado.setTipoLogradouro(this.getReplicatorFacade().getApiceTipoLogradouro(unico.getTipoLogradouro().getId()));
        }
        ApiceCidade cidade = this.getReplicatorFacade().getApiceCidade(unico.getCidade().getId());
        if (legado.getPk() == null) {
            legado.setPk(ApiceLogradouroPK.create((ApiceCidade)cidade));
        } else if (legado.getPk().getCidade() != null && !unico.getCidade().getId().equals(legado.getPk().getCidade().getIdUnico())) {
            throw new UnableToChangePKException(legado.getClass(), (Serializable)unico.getId());
        }
        return legado;
    }

    public Logradouro to(ApiceLogradouro legado, Logradouro unico) {
        unico.setDescricao(ReplicatorFacade.defaultString((String)legado.getDescricao()));
        unico.setId(legado.getIdUnico());
        unico.setInativo(Boolean.valueOf(legado.getAtivo() == false));
        unico.setCidade((Cidade)this.getReplicatorFacade().createReAttachEloDomain(Cidade.class, (Serializable)legado.getPk().getCidade().getIdUnico()));
        if (legado.getTipoLogradouro() != null) {
            unico.setTipoLogradouro((TipoLogradouro)this.getReplicatorFacade().createReAttachEloDomain(TipoLogradouro.class, (Serializable)legado.getTipoLogradouro().getIdUnico()));
        }
        return unico;
    }
}

