/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.replicate.apice;

import br.com.elotech.di.domain.Documento;
import br.com.elotech.di.domain.TipoDocumento;
import br.com.elotech.di.domain.apice.ApiceDocumentacao;
import br.com.elotech.di.domain.apice.ApiceTipoDocumento;
import br.com.elotech.di.replicate.support.AbstractReplicator;
import org.springframework.stereotype.Component;

@Component
public class ReplicatorDocumentoApice
extends AbstractReplicator<Documento, Long, ApiceDocumentacao> {
    public ApiceDocumentacao from(Documento unico, ApiceDocumentacao legado) {
        legado.setCodigoTce(unico.getCodigoTce());
        legado.setDescricao(unico.getDescricao());
        legado.setIdUnico(unico.getId());
        legado.setClassificacao(unico.getClassificacao());
        legado.setFisicajuridica(unico.getApresentadoPor());
        legado.setObrigatorioCertidao(unico.getObrigatorioCertidao());
        legado.setPossuiValidade(unico.getPossuiValidade());
        legado.setTipo(ApiceTipoDocumento.getApiceTipoDocumento((TipoDocumento)unico.getTipoDocumento()));
        return legado;
    }

    public Documento to(ApiceDocumentacao legado, Documento unico) {
        unico.setId(legado.getIdUnico());
        unico.setApresentadoPor(legado.getFisicajuridica());
        unico.setClassificacao(legado.getClassificacao());
        unico.setDescricao(legado.getDescricao());
        unico.setObrigatorioCertidao(legado.getObrigatorioCertidao());
        unico.setPossuiValidade(legado.getPossuiValidade());
        unico.setDescricao(legado.getDescricao());
        unico.setCodigoTce(legado.getCodigoTce());
        if (legado.getTipo() != null) {
            unico.setTipoDocumento(legado.getTipo().getTipoDocumento());
        }
        return unico;
    }
}

