/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.replicate.apice;

import br.com.elotech.di.domain.Cidade;
import br.com.elotech.di.domain.UF;
import br.com.elotech.di.domain.apice.ApiceCidade;
import br.com.elotech.di.replicate.support.AbstractReplicator;
import br.com.elotech.di.replicate.support.CidadeMerger;
import br.com.elotech.di.utils.EloNumberUtils;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReplicatorCidadeApice
extends AbstractReplicator<Cidade, Long, ApiceCidade> {
    private final CidadeMerger merger;

    @Autowired
    public ReplicatorCidadeApice(CidadeMerger merger) {
        this.merger = merger;
    }

    public ApiceCidade from(Cidade unico, ApiceCidade legado) {
        legado.setIbge(EloNumberUtils.toString((Long)unico.getCodigoIbge()));
        legado.setDescricao(unico.getDescricao());
        legado.setIdUnico(unico.getId());
        legado.setUf(this.getReplicatorFacade().getApiceUF(unico.getUf().getId()));
        legado.setCodAplic(EloNumberUtils.toString((Long)unico.getCodigoAplic()));
        legado.setAtivo(Boolean.valueOf(unico.getInativo() == false));
        return legado;
    }

    public Cidade to(ApiceCidade legado, Cidade unico) {
        if (StringUtils.isBlank((String)legado.getDescricao())) {
            unico.setDescricao("CONVERSAO");
        } else {
            unico.setDescricao(legado.getDescricao());
        }
        unico.setId(legado.getIdUnico());
        unico.setInativo(Boolean.valueOf(legado.getAtivo() == false));
        unico.setCodigoIbge(EloNumberUtils.toLong((String)legado.getIbge()));
        unico.setCodigoAplic(EloNumberUtils.toLong((String)legado.getCodAplic()));
        unico.setUf((UF)this.getReplicatorFacade().createReAttachEloDomain(UF.class, (Serializable)legado.getUf().getIdUnico()));
        return unico;
    }

    public Cidade merge(Cidade original, Cidade other) {
        return this.merger.merge(original, other);
    }
}

