/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.replicate.apice;

import br.com.elotech.di.domain.Bairro;
import br.com.elotech.di.domain.Cidade;
import br.com.elotech.di.domain.apice.ApiceBairro;
import br.com.elotech.di.domain.apice.ApiceBairroPK;
import br.com.elotech.di.domain.apice.ApiceCidade;
import br.com.elotech.di.exception.UnableToChangePKException;
import br.com.elotech.di.replicate.support.AbstractReplicator;
import br.com.elotech.di.replicate.support.ReplicatorFacade;
import java.io.Serializable;
import org.springframework.stereotype.Component;

@Component
public class ReplicatorBairroApice
extends AbstractReplicator<Bairro, Long, ApiceBairro> {
    public ApiceBairro from(Bairro unico, ApiceBairro legado) {
        legado.setDescricao(unico.getDescricao());
        legado.setIdUnico(unico.getId());
        legado.setAtivo(Boolean.valueOf(unico.getInativo() == false));
        ApiceCidade cidade = this.getReplicatorFacade().getApiceCidade(unico.getCidade().getId());
        if (legado.getPk() == null) {
            legado.setPk(ApiceBairroPK.create((ApiceCidade)cidade));
        } else if (legado.getPk().getCidade() != null && !unico.getCidade().getId().equals(legado.getPk().getCidade().getIdUnico())) {
            throw new UnableToChangePKException(legado.getClass(), (Serializable)unico.getId());
        }
        return legado;
    }

    public Bairro to(ApiceBairro legado, Bairro unico) {
        unico.setId(legado.getIdUnico());
        unico.setInativo(Boolean.valueOf(legado.getAtivo() == false));
        unico.setDescricao(ReplicatorFacade.defaultString((String)legado.getDescricao()));
        unico.setCidade((Cidade)this.getReplicatorFacade().createReAttachEloDomain(Cidade.class, (Serializable)legado.getPk().getCidade().getIdUnico()));
        return unico;
    }
}

