/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.replicate.aise;

import br.com.elotech.di.domain.Entidade;
import br.com.elotech.di.domain.TipoVeiculoPublicacao;
import br.com.elotech.di.domain.VeiculoPublicacao;
import br.com.elotech.di.domain.aise.AiseVeiculoPublicacao;
import br.com.elotech.di.replicate.support.AbstractReplicatorVeiculoPublicacao;
import br.com.elotech.di.replicate.support.Replicable;
import br.com.elotech.di.replicate.support.ReplicateAise;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class ReplicatorVeiculoPublicacaoAise
extends AbstractReplicatorVeiculoPublicacao<AiseVeiculoPublicacao>
implements ReplicateAise {
    public AiseVeiculoPublicacao from(VeiculoPublicacao unico, AiseVeiculoPublicacao legado) {
        super.from(unico, (Replicable)legado);
        legado.setCodigoTCE(unico.getCodigoAtosPessoal());
        legado.setDataAlteracao(unico.getDataAlteracao());
        legado.setDataCadastro(unico.getDataCadastro());
        legado.setDescricao(unico.getDescricao());
        legado.setIdUnico(unico.getId());
        TipoVeiculoPublicacao tipoVeiculo = Optional.ofNullable(unico.getTipoVeiculoPublicacao()).orElse(new TipoVeiculoPublicacao());
        legado.setTipoVeiculoPublicacao(tipoVeiculo.getAiseTipoPublicacaoAise());
        legado.setEntidade(this.getReplicatorFacade().getAiseEntidade(unico.getEntidade()));
        if (unico.getPessoa() != null) {
            legado.setCnpj(unico.getPessoa().getCnpjCpf());
        }
        return legado;
    }

    public VeiculoPublicacao to(AiseVeiculoPublicacao legado, VeiculoPublicacao unico) {
        Preconditions.checkState((legado.getEntidade() != null ? 1 : 0) != 0, (String)"%s entidade can't be null", (Object)legado.getClass().getSimpleName());
        unico.setEntidade((Entidade)this.getReplicatorFacade().createReAttachEloDomain(Entidade.class, (Serializable)legado.getEntidade().getIdUnico()));
        unico.setCodigoAtosPessoal(legado.getCodigoTCE());
        unico.setDataAlteracao(legado.getDataAlteracao());
        unico.setDataCadastro(legado.getDataCadastro());
        unico.setDescricao(legado.getDescricao());
        unico.setId(legado.getIdUnico());
        unico.setCodigoOperacao(VeiculoPublicacao.COD_OPERACAO_INVALIDA);
        return unico;
    }
}

