/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.replicate.aise;

import br.com.elotech.di.domain.Entidade;
import br.com.elotech.di.domain.Modulo;
import br.com.elotech.di.domain.Rg;
import br.com.elotech.di.domain.Usuario;
import br.com.elotech.di.domain.UsuarioEntidade;
import br.com.elotech.di.domain.UsuarioModulo;
import br.com.elotech.di.domain.aise.AiseEntidade;
import br.com.elotech.di.domain.aise.AiseModulo;
import br.com.elotech.di.domain.aise.AisePessoa;
import br.com.elotech.di.domain.aise.AiseUsuario;
import br.com.elotech.di.domain.aise.AiseUsuarioEntidade;
import br.com.elotech.di.domain.aise.AiseUsuarioModulo;
import br.com.elotech.di.replicate.support.AbstractReplicatorUsuario;
import br.com.elotech.di.replicate.support.ReplicateAise;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ReplicatorUsuarioAise
extends AbstractReplicatorUsuario<Usuario, Long, AiseUsuario>
implements ReplicateAise {
    public AiseUsuario from(Usuario unico, AiseUsuario legado) {
        legado.setAtivo(unico.getAtivo());
        legado.setId(StringUtils.defaultIfBlank((String)legado.getId(), (String)unico.getUsuario()));
        legado.setIdUnico(unico.getId());
        legado.setSenha(unico.getSenha());
        if (unico.getCpf() != null) {
            legado.setPessoa(this.getReplicatorFacade().getAisePessoaByCPF(unico.getCpf()));
        }
        legado.setUsuarioResponsavel(this.getReplicatorFacade().getAiseUsuario(unico.getUsuarioResponsavel()));
        if (this.getReplicatorFacade().existsUnicoEntidades()) {
            this.createLegadoEntidades(unico, legado);
        }
        this.createLegadoModulos(unico, legado);
        return legado;
    }

    private void createLegadoModulos(Usuario unico, AiseUsuario legado) {
        legado.getModulos().clear();
        List modulos = unico.getModulos();
        for (UsuarioModulo usuarioModulo : modulos) {
            AiseModulo aiseModulo = this.getReplicatorFacade().getAiseModulo(usuarioModulo.getModulo());
            legado.getModulos().add(AiseUsuarioModulo.of((AiseUsuario)legado, (AiseModulo)aiseModulo));
        }
    }

    private void createLegadoEntidades(Usuario unico, AiseUsuario legado) {
        legado.getEntidades().clear();
        List entidades = unico.getEntidades();
        for (UsuarioEntidade usuarioEntidade : entidades) {
            AiseEntidade aiseEntidade = this.getReplicatorFacade().getAiseEntidade(usuarioEntidade.getEntidade());
            if (Objects.nonNull(aiseEntidade)) {
                legado.getEntidades().add(AiseUsuarioEntidade.of((AiseUsuario)legado, (AiseEntidade)aiseEntidade).withPadrao(usuarioEntidade.getPrincipal()));
                continue;
            }
            this.getLog().debug("N\u00e3o foi encontrado entidade do legado para o usu\u00e1rio \u00fanico {}", (Object)unico);
        }
    }

    private void attrAisePessoaValues(Usuario unico, AiseUsuario legado) {
        if (legado.getPessoa() != null) {
            AisePessoa aisePessoa = legado.getPessoa();
            unico.setNome(aisePessoa.getNome());
            unico.setCpf(aisePessoa.getCnpjCpf());
            unico.setRg(new Rg().withNumero(aisePessoa.getRg()).withDataEmissao(aisePessoa.getDataEmissao()).withOrgaoEmissor(aisePessoa.getOrgaoEmissor()));
            if (aisePessoa.getContatoPrincipal() != null) {
                unico.setEmail(aisePessoa.getContatoPrincipal().getEmail());
            }
        }
    }

    public Usuario to(AiseUsuario legado, Usuario unico) {
        this.attrAisePessoaValues(unico, legado);
        unico.setId(legado.getIdUnico());
        if (unico.hasToSetUsuario()) {
            unico.setUsuario(legado.getId());
            unico.setUsuarioOriginal(legado.getId());
        }
        AiseUsuario usuarioResponsavel = Optional.ofNullable(legado.getUsuarioResponsavel()).orElse(new AiseUsuario());
        unico.setUsuarioResponsavel((Usuario)this.getReplicatorFacade().createReAttachEloDomain(Usuario.class, (Serializable)usuarioResponsavel.getIdUnico()));
        unico.setSenha(legado.getSenha());
        unico.setAtivo(legado.getAtivo());
        this.createUnicoEntidades(unico, legado);
        this.createUnicoModulos(unico, legado);
        return unico;
    }

    private void createUnicoModulos(Usuario unico, AiseUsuario legado) {
        unico.getModulos().clear();
        Set legadoModulos = legado.getModulos();
        for (AiseUsuarioModulo aiseUsuarioModulo : legadoModulos) {
            Modulo modulo = (Modulo)this.getReplicatorFacade().createReAttachEloDomain(Modulo.class, (Serializable)aiseUsuarioModulo.getPk().getModulo().getIdUnico());
            unico.getModulos().add(UsuarioModulo.of((Modulo)modulo).withPrincipal(Boolean.valueOf(false)));
        }
    }

    private void createUnicoEntidades(Usuario unico, AiseUsuario legado) {
        unico.getEntidades().clear();
        Set legadoEntidades = legado.getEntidades();
        for (AiseUsuarioEntidade aiseUsuarioEntidade : legadoEntidades) {
            Entidade entidade = (Entidade)this.getReplicatorFacade().createReAttachEloDomain(Entidade.class, (Serializable)aiseUsuarioEntidade.getPk().getEntidade().getIdUnico());
            if (Objects.nonNull(entidade)) {
                unico.getEntidades().add(UsuarioEntidade.of((Entidade)entidade).withPrincipal(aiseUsuarioEntidade.getPadrao()));
                continue;
            }
            this.getLog().debug("N\u00e3o foi encontrado entidade do \u00fanico para o usu\u00e1rio legado {}", (Object)legado);
        }
    }
}

