/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.replicate.aise;

import br.com.elotech.di.domain.Pais;
import br.com.elotech.di.domain.UF;
import br.com.elotech.di.domain.aise.AisePais;
import br.com.elotech.di.domain.aise.AiseUnidadeFederacao;
import br.com.elotech.di.domain.aise.AiseUnidadeFederacaoPK;
import br.com.elotech.di.exception.UnableToChangePKException;
import br.com.elotech.di.replicate.support.AbstractReplicator;
import br.com.elotech.di.replicate.support.ReplicateAise;
import java.io.Serializable;
import org.springframework.stereotype.Component;

@Component
public class ReplicatorUnidadeFederacaoAise
extends AbstractReplicator<UF, Long, AiseUnidadeFederacao>
implements ReplicateAise {
    public AiseUnidadeFederacao from(UF unico, AiseUnidadeFederacao legado) {
        legado.setDescricao(unico.getDescricao());
        legado.setIdUnico(unico.getId());
        AisePais pais = this.getReplicatorFacade().getAisePais(unico.getPais().getId());
        if (legado.getPk() == null) {
            legado.setPk(AiseUnidadeFederacaoPK.create((String)unico.getSigla(), (AisePais)pais));
        } else if (legado.getPk().getPais() != null && !unico.getPais().getId().equals(legado.getPk().getPais().getIdUnico())) {
            throw new UnableToChangePKException(legado.getClass(), (Serializable)unico.getId());
        }
        return legado;
    }

    public UF to(AiseUnidadeFederacao legado, UF unico) {
        unico.setId(legado.getIdUnico());
        unico.setSigla(legado.getPk().getSigla());
        unico.setDescricao(legado.getDescricao());
        if (legado.getPk().getPais() != null) {
            unico.setPais((Pais)this.getReplicatorFacade().createReAttachEloDomain(Pais.class, (Serializable)legado.getPk().getPais().getIdUnico()));
        }
        return unico;
    }
}

