/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.replicate.aise;

import br.com.elotech.di.domain.Pessoa;
import br.com.elotech.di.domain.PessoaDocumento;
import br.com.elotech.di.domain.TipoDocumento;
import br.com.elotech.di.domain.aise.AiseDocumentoPessoa;
import br.com.elotech.di.domain.aise.AiseDocumentoPessoaPK;
import br.com.elotech.di.domain.aise.AisePessoa;
import br.com.elotech.di.domain.aise.ClasseDefinicao;
import br.com.elotech.di.replicate.support.ReplicatorFacade;

public class ReplicatorPessoaAiseDocumentos {
    public static final String NUMERO_FIXO = "SEM N\u00daMERO";
    private final ReplicatorFacade replicatorFacade;

    public ReplicatorPessoaAiseDocumentos(ReplicatorFacade replicatorFacade) {
        this.replicatorFacade = replicatorFacade;
    }

    public void createAiseDocumentos(Pessoa unico, AisePessoa legado) {
        legado.getDocumentos().clear();
        for (PessoaDocumento documentoPessoa : unico.getDocumentos()) {
            AiseDocumentoPessoa aiseDocumentoPessoa = new AiseDocumentoPessoa();
            aiseDocumentoPessoa.setPk(AiseDocumentoPessoaPK.create((AisePessoa)legado));
            if (documentoPessoa.getDoc().getDocumento() != null) {
                aiseDocumentoPessoa.setTipoDocumento((ClasseDefinicao)ClasseDefinicao.getToAiseTipoDocumento().get(documentoPessoa.getDoc().getDocumento().getTipoDocumento()));
                if (aiseDocumentoPessoa.getTipoDocumento() == null) {
                    aiseDocumentoPessoa.setTipoDocumento(ClasseDefinicao.OUTROS);
                }
            }
            aiseDocumentoPessoa.setArquivo(documentoPessoa.getDoc().getArquivo());
            aiseDocumentoPessoa.setDataAlteracao(documentoPessoa.getDoc().getDataAlteracao());
            aiseDocumentoPessoa.setDataInclusao(documentoPessoa.getDoc().getDataEmissao());
            legado.getDocumentos().add(aiseDocumentoPessoa);
        }
    }

    public void createDocumentosUnico(Pessoa unico, AisePessoa legado) {
        unico.getDocumentos().clear();
        for (AiseDocumentoPessoa aiseDocumentacao : legado.getDocumentos()) {
            PessoaDocumento documentoPessoa = new PessoaDocumento();
            documentoPessoa.getDoc().setArquivo(aiseDocumentacao.getArquivo());
            documentoPessoa.getDoc().setDataAlteracao(aiseDocumentacao.getDataAlteracao());
            documentoPessoa.getDoc().setDataEmissao(aiseDocumentacao.getDataInclusao());
            documentoPessoa.getDoc().setDataValidade(null);
            documentoPessoa.getDoc().setNumeroDocumento(NUMERO_FIXO);
            TipoDocumento tipoDocumento = TipoDocumento.OUTROS;
            if (aiseDocumentacao.getTipoDocumento() != null) {
                tipoDocumento = aiseDocumentacao.getTipoDocumento().getTipoDocumento();
            }
            documentoPessoa.getDoc().setDocumento(this.replicatorFacade.findFirstByTipoDocumento(tipoDocumento));
            unico.getDocumentos().add(documentoPessoa);
        }
    }
}

