/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.replicate.aise;

import br.com.elotech.core.web.request.ContextHolder;
import br.com.elotech.di.config.UnicoProperties;
import br.com.elotech.di.domain.Agencia;
import br.com.elotech.di.domain.Bairro;
import br.com.elotech.di.domain.Banco;
import br.com.elotech.di.domain.Cidade;
import br.com.elotech.di.domain.Logradouro;
import br.com.elotech.di.domain.Pessoa;
import br.com.elotech.di.domain.PessoaBanco;
import br.com.elotech.di.domain.PessoaContato;
import br.com.elotech.di.domain.PessoaEndereco;
import br.com.elotech.di.domain.PessoaRH;
import br.com.elotech.di.domain.Rg;
import br.com.elotech.di.domain.UF;
import br.com.elotech.di.domain.aise.AiseBancoPessoa;
import br.com.elotech.di.domain.aise.AiseContatoPessoa;
import br.com.elotech.di.domain.aise.AiseEnderecoPessoa;
import br.com.elotech.di.domain.aise.AisePessoa;
import br.com.elotech.di.domain.aise.AisePessoaRH;
import br.com.elotech.di.replicate.aise.ReplicatorPessoaAiseDocumentos;
import br.com.elotech.di.replicate.aise.ReplicatorPessoaAiseImagem;
import br.com.elotech.di.replicate.support.AbstractReplicator;
import br.com.elotech.di.replicate.support.ReplicateAise;
import br.com.elotech.di.replicate.support.ReplicatorFacade;
import br.com.elotech.di.repository.Agencias;
import br.com.elotech.di.utils.EloNumberUtils;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReplicatorPessoaAise
extends AbstractReplicator<Pessoa, Long, AisePessoa>
implements ReplicateAise {
    private final ModelMapper modelMapper;
    private final Agencias agencias;
    private final UnicoProperties unicoProperties;
    private final ReplicatorPessoaAiseImagem replicatorPessoaAiseImagem = new ReplicatorPessoaAiseImagem();

    @Autowired
    public ReplicatorPessoaAise(ModelMapper modelMapper, Agencias agencias, UnicoProperties unicoProperties) {
        this.modelMapper = modelMapper;
        this.agencias = agencias;
        this.unicoProperties = unicoProperties;
    }

    public AisePessoa from(Pessoa unico, AisePessoa legado) {
        this.modelMapper.map((Object)unico, (Object)legado);
        if (unico.getDataAlteracao() != null) {
            legado.setDataAlteracao(unico.getDataAlteracao().toLocalDate());
        }
        legado.setDataInclusao(unico.getDataCadastro());
        legado.setIdUnico(unico.getId());
        if (this.unicoProperties.getIdunico().booleanValue()) {
            legado.setPessoa(unico.getId());
        }
        if (unico.getRg() != null) {
            legado.setDataEmissao(unico.getRg().getDataEmissao());
            legado.setRg(unico.getRg().getNumero());
            legado.setOrgaoEmissor(unico.getRg().getOrgaoEmissor());
            if (unico.getRg().getUf() != null) {
                legado.setEstadoEmissor(this.getReplicatorFacade().getAiseUF(unico.getRg().getUf().getId()));
            }
        } else {
            legado.setOrgaoEmissor(null);
            legado.setDataEmissao(null);
            legado.setRg(null);
            legado.setEstadoEmissor(null);
        }
        legado.setIdTcePR(EloNumberUtils.toString((Long)unico.getIdTcePR()));
        legado.setFornecedorSiscop(unico.getCodigoSiscop());
        legado.setUsuarioInclusao(this.getReplicatorFacade().getUsuario());
        if (ContextHolder.hasHeadersValue()) {
            legado.setActiveFormOrigem(ContextHolder.getHeaderActiveView());
        }
        this.createAiseEndereco(unico, legado);
        this.createAiseContato(unico, legado);
        this.createAiseContaBancaria(unico, legado);
        this.createAisePessoaRH(unico, legado);
        this.getReplicatorDocumentos().createAiseDocumentos(unico, legado);
        this.replicatorPessoaAiseImagem.createLegadoImagem(legado, unico);
        return legado;
    }

    private ReplicatorPessoaAiseDocumentos getReplicatorDocumentos() {
        return new ReplicatorPessoaAiseDocumentos(this.getReplicatorFacade());
    }

    private void createAisePessoaRH(Pessoa unico, AisePessoa legado) {
        if (this.hasToCreatePessoaRH(unico)) {
            AisePessoaRH pessoaRH = legado.getPessoaRH();
            if (pessoaRH == null) {
                pessoaRH = AisePessoaRH.of((AisePessoa)legado);
                legado.setPessoaRH(pessoaRH);
            }
            pessoaRH.setPis(unico.getPis());
            pessoaRH.setGrauinstrucao(unico.getEscolaridade());
            pessoaRH.setDataNascimento(unico.getDataNascimento());
            pessoaRH.setRegistroGeral(null);
            if (unico.getRg() != null) {
                pessoaRH.setRegistroGeral(unico.getRg().getNumero());
            }
            pessoaRH.setCidadenascimento(null);
            if (unico.getRh() != null) {
                if (unico.getRh().getCidadeNascimento() != null) {
                    pessoaRH.setCidadenascimento(this.getReplicatorFacade().getAiseCidade(unico.getRh().getCidadeNascimento().getId()));
                }
                if (unico.getRh().getCidadeTitulo() != null) {
                    pessoaRH.setCidadetitulo(this.getReplicatorFacade().getAiseCidade(unico.getRh().getCidadeTitulo().getId()));
                }
                pessoaRH.setPessoaRHComum(unico.getRh().getComum());
            }
        }
    }

    private boolean hasToCreatePessoaRH(Pessoa unico) {
        return unico.getEscolaridade() != null || unico.getDataNascimento() != null || unico.getRg() != null || unico.getRh() != null || unico.getPis() != null;
    }

    private void createAiseContaBancaria(Pessoa unico, AisePessoa legado) {
        legado.getBancos().clear();
        legado.setContaBancariaPrincipal(null);
        List contasBancarias = unico.getBancosPessoa();
        Long codigoContaBancaria = 1L;
        for (PessoaBanco contasBancariasPessoa : contasBancarias) {
            AiseBancoPessoa contaBancariaPessoa = new AiseBancoPessoa();
            contaBancariaPessoa.getPk().setPessoa(legado);
            Long l = codigoContaBancaria;
            codigoContaBancaria = codigoContaBancaria + 1L;
            contaBancariaPessoa.getPk().setCodigo(l);
            contaBancariaPessoa.setAgencia(null);
            if (contasBancariasPessoa.getConta().getAgencia() != null) {
                contaBancariaPessoa.setAgencia(this.getReplicatorFacade().getAiseAgencia(contasBancariasPessoa.getConta().getAgencia().getId()));
            }
            contaBancariaPessoa.setConta(contasBancariasPessoa.getConta().getConta());
            contaBancariaPessoa.setOrdemBancaria(contasBancariasPessoa.getConta().getOrdemBancaria());
            contaBancariaPessoa.setTipoConta(contasBancariasPessoa.getConta().getTipoConta());
            contaBancariaPessoa.setIdUnico(contasBancariasPessoa.getId());
            if (contasBancariasPessoa.getConta().getPrincipal().booleanValue()) {
                legado.setContaBancariaPrincipal(contaBancariaPessoa);
            }
            legado.getBancos().add(contaBancariaPessoa);
        }
    }

    private void createAiseContato(Pessoa unico, AisePessoa legado) {
        legado.getContatos().clear();
        legado.setContatoPrincipal(null);
        List contatos = unico.getContatos();
        Long codigoContato = 1L;
        for (PessoaContato contatoPessoa : contatos) {
            AiseContatoPessoa contato = new AiseContatoPessoa();
            contato.getPk().setPessoa(legado);
            Long l = codigoContato;
            codigoContato = codigoContato + 1L;
            contato.getPk().setCodigo(l);
            contato.setEmail(contatoPessoa.getContato().getEmail());
            contato.setNome(contatoPessoa.getContato().getNome());
            contato.setRepresentanteLegal(contatoPessoa.getContato().getRepresentanteLegal());
            contato.setHomepage(contatoPessoa.getContato().getHomePage());
            contato.setTelefonecelular(contatoPessoa.getContato().getTelefoneCelular());
            contato.setTelefonecomercial(contatoPessoa.getContato().getTelefoneComercial());
            contato.setTelefonefax(contatoPessoa.getContato().getTelefoneFax());
            contato.setTelefoneresidencial(contatoPessoa.getContato().getTelefoneResidencial());
            if (contatoPessoa.getPrincipal().booleanValue()) {
                legado.setContatoPrincipal(contato);
            }
            contato.setIdUnico(contatoPessoa.getId());
            legado.getContatos().add(contato);
        }
    }

    private void createAiseEndereco(Pessoa unico, AisePessoa legado) {
        legado.getEnderecos().clear();
        legado.setEnderecoPrincipal(null);
        List enderecos = unico.getEnderecos();
        long codigoEndereco = 1L;
        for (PessoaEndereco enderecoPessoa : enderecos) {
            AiseEnderecoPessoa endereco = new AiseEnderecoPessoa();
            endereco.getPk().setPessoa(legado);
            endereco.getPk().setCodigo(Long.valueOf(codigoEndereco++));
            endereco.setCep(enderecoPessoa.getEndereco().getCep());
            endereco.setComplemento(enderecoPessoa.getEndereco().getComplemento());
            endereco.setDataAlteracao(LocalDate.now());
            endereco.setDomicilioFiscalEstabelecido("S");
            endereco.setNumero(enderecoPessoa.getEndereco().getNumero());
            endereco.setTipoEndereco(enderecoPessoa.getEndereco().getTipo());
            endereco.setBairro(null);
            endereco.setCidade(null);
            endereco.setLogradouro(null);
            endereco.setUnidadeFederacao(null);
            if (enderecoPessoa.getEndereco().getBairro() != null) {
                endereco.setBairro(this.getReplicatorFacade().getAiseBairro(enderecoPessoa.getEndereco().getBairro().getId()));
            }
            if (enderecoPessoa.getEndereco().getCidade() != null) {
                endereco.setCidade(this.getReplicatorFacade().getAiseCidade(enderecoPessoa.getEndereco().getCidade().getId()));
                if (enderecoPessoa.getEndereco().getCidade().getUf() != null) {
                    endereco.setUnidadeFederacao(this.getReplicatorFacade().getAiseUF(enderecoPessoa.getEndereco().getCidade().getUf().getId()));
                }
            }
            if (enderecoPessoa.getEndereco().getLogradouro() != null) {
                endereco.setLogradouro(this.getReplicatorFacade().getAiseLogradouro(enderecoPessoa.getEndereco().getLogradouro().getId()));
            }
            if (enderecoPessoa.getPrincipal().booleanValue()) {
                legado.setEnderecoPrincipal(endereco);
            }
            endereco.setIdUnico(enderecoPessoa.getId());
            legado.getEnderecos().add(endereco);
        }
    }

    public Pessoa to(AisePessoa legado, Pessoa unico) {
        this.modelMapper.map((Object)legado, (Object)unico);
        if (this.unicoProperties.getIdunico().booleanValue()) {
            unico.setId(legado.getPessoa());
        }
        if (legado.getDataAlteracao() != null) {
            unico.setDataAlteracao(LocalDateTime.of(legado.getDataAlteracao(), LocalTime.MIDNIGHT));
        }
        unico.setDataCadastro(legado.getDataInclusao());
        unico.setNome(ReplicatorFacade.defaultString((String)legado.getNome(), (int)4));
        unico.setNomeSocial(legado.getNomeSocial());
        if (!StringUtils.isBlank((String)legado.getRg())) {
            UF uf = null;
            if (legado.getEstadoEmissor() != null) {
                uf = (UF)this.getReplicatorFacade().createReAttachEloDomain(UF.class, (Serializable)legado.getEstadoEmissor().getIdUnico());
            }
            unico.setRg(new Rg().withDataEmissao(legado.getDataEmissao()).withNumero(legado.getRg()).withOrgaoEmissor(legado.getOrgaoEmissor()).withUf(uf));
        }
        this.createUnicoEndereco(legado, unico);
        this.createUnicoContato(legado, unico);
        this.createUnicoContaBancaria(legado, unico);
        this.createUnicoPessoaRH(legado, unico);
        this.getReplicatorDocumentos().createDocumentosUnico(unico, legado);
        this.replicatorPessoaAiseImagem.createUnicoImagem(legado, unico);
        ReplicatorFacade.checkEnderecoPrincipalIfDontHave((Pessoa)unico);
        ReplicatorFacade.checkContatoPrincipalIfDontHave((Pessoa)unico);
        ReplicatorFacade.checkContaBancariaPrincipalIfDontHave((Pessoa)unico);
        return unico;
    }

    private void createUnicoPessoaRH(AisePessoa legado, Pessoa unico) {
        unico.setRh(null);
        unico.setDataNascimento(legado.getDataNascimento());
        if (legado.getPessoaRH() != null) {
            unico.setDataNascimento(legado.getPessoaRH().getDataNascimento());
            unico.setPis(legado.getPessoaRH().getPis());
            unico.setRh(new PessoaRH());
            unico.setEscolaridade(legado.getPessoaRH().getGrauinstrucao());
            unico.setPessoal(Boolean.valueOf(true));
            if (legado.getPessoaRH().getCidadenascimento() != null) {
                unico.getRh().setCidadeNascimento((Cidade)this.getReplicatorFacade().createReAttachEloDomain(Cidade.class, (Serializable)legado.getPessoaRH().getCidadenascimento().getIdUnico()));
            }
            if (legado.getPessoaRH().getCidadetitulo() != null) {
                unico.getRh().setCidadeTitulo((Cidade)this.getReplicatorFacade().createReAttachEloDomain(Cidade.class, (Serializable)legado.getPessoaRH().getCidadetitulo().getIdUnico()));
            }
            if (!Objects.isNull(legado.getPessoaRH().getPessoaRHComum())) {
                unico.getRh().getComum().copyPropertiesFrom(legado.getPessoaRH().getPessoaRHComum());
            }
        }
    }

    private void createUnicoContaBancaria(AisePessoa legado, Pessoa unico) {
        unico.getBancosPessoa().clear();
        List bancos = legado.getBancos();
        for (AiseBancoPessoa contaBancaria : bancos) {
            PessoaBanco unicoContaBancaria = new PessoaBanco();
            if (contaBancaria.getAgencia() != null) {
                unicoContaBancaria.getConta().setAgencia((Agencia)this.agencias.findOne((Object)contaBancaria.getAgencia().getIdUnico()));
                unicoContaBancaria.getConta().getAgencia().setBanco((Banco)this.getReplicatorFacade().createReAttachEloDomain(Banco.class, (Serializable)contaBancaria.getAgencia().getPk().getBanco().getIdUnico()));
            }
            unicoContaBancaria.getConta().setConta(contaBancaria.getConta());
            unicoContaBancaria.getConta().setOrdemBancaria(contaBancaria.getOrdemBancaria());
            unicoContaBancaria.getConta().setTipoConta(contaBancaria.getTipoConta());
            if (legado.getContaBancariaPrincipal() != null) {
                unicoContaBancaria.getConta().setPrincipal(Boolean.valueOf(legado.getContaBancariaPrincipal().equals((Object)contaBancaria)));
            }
            unicoContaBancaria.calculeValidaDigito();
            unico.getBancosPessoa().add(unicoContaBancaria);
        }
    }

    private void createUnicoEndereco(AisePessoa legado, Pessoa unico) {
        unico.getEnderecos().clear();
        List enderecos = legado.getEnderecos();
        for (AiseEnderecoPessoa enderecoPessoa : enderecos) {
            PessoaEndereco unicoEndereco = new PessoaEndereco();
            unicoEndereco.getEndereco().setCep(enderecoPessoa.getCep());
            unicoEndereco.getEndereco().setComplemento(enderecoPessoa.getComplemento());
            unicoEndereco.getEndereco().setNumero(enderecoPessoa.getNumero());
            unicoEndereco.getEndereco().setTipo(enderecoPessoa.getTipoEndereco());
            unicoEndereco.setPrincipal(Boolean.valueOf(false));
            if (legado.getEnderecoPrincipal() != null) {
                unicoEndereco.setPrincipal(Boolean.valueOf(legado.getEnderecoPrincipal().equals((Object)enderecoPessoa)));
            }
            unicoEndereco.getEndereco().setLogradouro(null);
            if (enderecoPessoa.getCidade() == null) {
                unicoEndereco.getEndereco().setCidade(this.getReplicatorFacade().createOrGetCidadeInvalida());
            } else {
                unicoEndereco.getEndereco().setCidade((Cidade)this.getReplicatorFacade().createReAttachEloDomain(Cidade.class, (Serializable)enderecoPessoa.getCidade().getIdUnico()));
            }
            if (enderecoPessoa.getBairro() == null) {
                unicoEndereco.getEndereco().setBairro(this.getReplicatorFacade().createOrGetBairroInvalido(Bairro.BAIRRO_INVALIDO.getDescricao(), unicoEndereco.getEndereco().getCidade()));
            } else {
                unicoEndereco.getEndereco().setBairro((Bairro)this.getReplicatorFacade().createReAttachEloDomain(Bairro.class, (Serializable)enderecoPessoa.getBairro().getIdUnico()));
            }
            if (enderecoPessoa.getLogradouro() == null) {
                unicoEndereco.getEndereco().setLogradouro(this.getReplicatorFacade().createOrGetLogradouroInvalido(Logradouro.LOGRADOURO_INVALIDO.getDescricao(), unicoEndereco.getEndereco().getCidade()));
            } else {
                unicoEndereco.getEndereco().setLogradouro((Logradouro)this.getReplicatorFacade().createReAttachEloDomain(Logradouro.class, (Serializable)enderecoPessoa.getLogradouro().getIdUnico()));
            }
            unico.getEnderecos().add(unicoEndereco);
        }
    }

    private void createUnicoContato(AisePessoa legado, Pessoa unico) {
        unico.getContatos().clear();
        List contatos = legado.getContatos();
        for (AiseContatoPessoa contatoPessoa : contatos) {
            PessoaContato unicoContato = new PessoaContato();
            unicoContato.getContato().setNome(contatoPessoa.getNome());
            unicoContato.getContato().setEmail(contatoPessoa.getEmail());
            unicoContato.getContato().setHomePage(contatoPessoa.getHomepage());
            if (contatoPessoa.getRepresentanteLegal() != null) {
                unicoContato.getContato().setRepresentanteLegal(contatoPessoa.getRepresentanteLegal());
            }
            unicoContato.getContato().setTelefoneCelular(contatoPessoa.getTelefonecelular());
            unicoContato.getContato().setTelefoneComercial(contatoPessoa.getTelefonecomercial());
            unicoContato.getContato().setTelefoneFax(contatoPessoa.getTelefonefax());
            unicoContato.getContato().setTelefoneResidencial(contatoPessoa.getTelefoneresidencial());
            unicoContato.setPrincipal(Boolean.valueOf(false));
            if (legado.getContatoPrincipal() != null) {
                unicoContato.setPrincipal(Boolean.valueOf(legado.getContatoPrincipal().equals((Object)contatoPessoa)));
            }
            unico.getContatos().add(unicoContato);
        }
    }
}

