/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.replicate.aise;

import br.com.elotech.di.domain.Modulo;
import br.com.elotech.di.domain.aise.AiseModulo;
import br.com.elotech.di.replicate.support.AbstractReplicator;
import br.com.elotech.di.repository.Modulos;
import br.com.elotech.di.utils.EloNumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReplicatorModuloAise
extends AbstractReplicator<Modulo, Long, AiseModulo> {
    @Autowired
    private Modulos modulos;

    public void setModulos(Modulos modulos) {
        this.modulos = modulos;
    }

    public AiseModulo from(Modulo unico, AiseModulo legado) {
        legado.setId(Modulo.format((Long)unico.getId()));
        legado.setDescricao(unico.getDescricao());
        legado.setPath(unico.getPath());
        legado.setTipo(unico.getTipoModulo());
        legado.setAcessoRelatorio(unico.getControlaAcessoRelatorio());
        legado.setIdUnico(unico.getId());
        return legado;
    }

    public Modulo to(AiseModulo legado, Modulo unico) {
        Long codigo = EloNumberUtils.toLong((String)legado.getId());
        unico.setTipoModulo(legado.getTipo());
        unico.setControlaAcessoRelatorio(legado.getAcessoRelatorio());
        unico.setId(codigo);
        unico.definePathByModuloEnum();
        unico.setDescricao(legado.getDescricao());
        Modulo modulo = (Modulo)this.modulos.findOne((Object)codigo);
        if (modulo != null) {
            unico.setDescricao(modulo.getDescricao());
        }
        return unico;
    }
}

