/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.replicate.aise;

import br.com.elotech.di.domain.Cidade;
import br.com.elotech.di.domain.Logradouro;
import br.com.elotech.di.domain.TipoLogradouro;
import br.com.elotech.di.domain.aise.AiseCidade;
import br.com.elotech.di.domain.aise.AiseLogradouro;
import br.com.elotech.di.domain.aise.AiseLogradouroPK;
import br.com.elotech.di.exception.UnableToChangePKException;
import br.com.elotech.di.replicate.support.AbstractReplicator;
import br.com.elotech.di.replicate.support.ReplicateAise;
import br.com.elotech.di.replicate.support.ReplicatorFacade;
import java.io.Serializable;
import org.springframework.stereotype.Component;

@Component
public class ReplicatorLogradouroAise
extends AbstractReplicator<Logradouro, Long, AiseLogradouro>
implements ReplicateAise {
    public AiseLogradouro from(Logradouro unico, AiseLogradouro legado) {
        legado.setIdUnico(unico.getId());
        legado.setDescricao(unico.getDescricao());
        if (unico.getTipoLogradouro() != null) {
            legado.setTipoLogradouro(this.getReplicatorFacade().getAiseTipoLogradouro(unico.getTipoLogradouro().getId()));
        }
        legado.setLocalizacao(null);
        legado.setLogradouroinicio(null);
        legado.setDescricaoAnterior(unico.getDescricao());
        legado.setInativo(unico.getInativo());
        AiseCidade cidade = this.getReplicatorFacade().getAiseCidade(unico.getCidade().getId());
        if (legado.getPk() == null) {
            legado.setPk(AiseLogradouroPK.create((AiseCidade)cidade));
        } else if (legado.getPk().getCidade() != null && !unico.getCidade().getId().equals(legado.getPk().getCidade().getIdUnico())) {
            throw new UnableToChangePKException(legado.getClass(), (Serializable)unico.getId());
        }
        return legado;
    }

    public Logradouro to(AiseLogradouro legado, Logradouro unico) {
        unico.setDescricao(ReplicatorFacade.defaultString((String)legado.getDescricao()));
        unico.setId(legado.getIdUnico());
        unico.setInativo(legado.getInativo());
        unico.setCidade((Cidade)this.getReplicatorFacade().createReAttachEloDomain(Cidade.class, (Serializable)legado.getPk().getCidade().getIdUnico()));
        if (legado.getTipoLogradouro() != null) {
            unico.setTipoLogradouro((TipoLogradouro)this.getReplicatorFacade().createReAttachEloDomain(TipoLogradouro.class, (Serializable)legado.getTipoLogradouro().getIdUnico()));
        }
        return unico;
    }
}

