/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.replicate.aise;

import br.com.elotech.di.domain.LeiAto;
import br.com.elotech.di.domain.LeiAtoPublicacao;
import br.com.elotech.di.domain.VeiculoPublicacao;
import br.com.elotech.di.domain.aise.AiseAto;
import br.com.elotech.di.domain.aise.AiseAtoPublicacao;
import br.com.elotech.di.replicate.support.BaseAbstractReplicator;
import br.com.elotech.di.replicate.support.ReplicateAise;
import br.com.elotech.di.replicate.support.ReplicatorAdditionalInfo;
import java.io.Serializable;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ReplicatorLeiAtoAiseAdditional
extends BaseAbstractReplicator<LeiAto, Long, AiseAto>
implements ReplicatorAdditionalInfo<LeiAto, Long, AiseAto>,
ReplicateAise {
    private void createUnicoPublicacoes(LeiAto unico, AiseAto legado) {
        for (AiseAtoPublicacao aiseAtoPublicacao : legado.getPublicacoes()) {
            if (aiseAtoPublicacao.getVeiculoPublicacao() == null || aiseAtoPublicacao.getVeiculoPublicacao().getIdUnico() == null) continue;
            LeiAtoPublicacao publicacao = new LeiAtoPublicacao();
            publicacao.setAnoEdicao(aiseAtoPublicacao.getAnoEdicao());
            publicacao.setDataPublicacao(aiseAtoPublicacao.getDataPublicacao());
            publicacao.setNumeroEdicao(aiseAtoPublicacao.getNumeroEdicao());
            publicacao.setVeiculoPublicacao((VeiculoPublicacao)this.getReplicatorFacade().createReAttachEloDomain(VeiculoPublicacao.class, (Serializable)aiseAtoPublicacao.getVeiculoPublicacao().getIdUnico()));
            publicacao.setPagina(aiseAtoPublicacao.getPagina());
            unico.getPublicacoes().add(publicacao);
        }
        if (!unico.getPublicacoes().isEmpty()) {
            ((LeiAtoPublicacao)unico.getPublicacoes().get(0)).setPrincipal(Boolean.valueOf(true));
        }
    }

    private void createLegadoPublicacoes(LeiAto unico, AiseAto legado) {
        try {
            legado.getPublicacoes().clear();
            List unicoPublicacoes = unico.getPublicacoes();
            for (LeiAtoPublicacao leiAtoPublicacao : unicoPublicacoes) {
                AiseAtoPublicacao aiseAtoPublicacao = AiseAtoPublicacao.of((AiseAto)legado);
                aiseAtoPublicacao.setAnoEdicao(leiAtoPublicacao.getAnoEdicao());
                aiseAtoPublicacao.setDataPublicacao(leiAtoPublicacao.getDataPublicacao());
                aiseAtoPublicacao.setNumeroEdicao(leiAtoPublicacao.getNumeroEdicao());
                aiseAtoPublicacao.setVeiculoPublicacao(this.getReplicatorFacade().getAiseVeiculoPublicacao(leiAtoPublicacao.getVeiculoPublicacao()));
                aiseAtoPublicacao.setPagina(leiAtoPublicacao.getPagina());
                legado.getPublicacoes().add(aiseAtoPublicacao);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public AiseAto from(LeiAto unico, AiseAto legado) {
        if (unico.getLeiAut() == null) {
            legado.setLeiAutorizativa(null);
        } else {
            legado.setLeiAutorizativa(this.getReplicatorFacade().getAiseLeiAto(unico.getLeiAut()));
        }
        this.createLegadoPublicacoes(unico, legado);
        return legado;
    }

    public LeiAto to(AiseAto legado, LeiAto unico) {
        if (legado.getLeiAutorizativa() == null) {
            unico.setLeiAut(null);
        } else {
            unico.setLeiAut((LeiAto)this.getReplicatorFacade().createReAttachEloDomain(LeiAto.class, (Serializable)legado.getLeiAutorizativa().getIdUnico()));
        }
        this.createUnicoPublicacoes(unico, legado);
        return unico;
    }
}

