/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.replicate.aise;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.di.domain.Entidade;
import br.com.elotech.di.domain.LeiAto;
import br.com.elotech.di.domain.LeiAtoArquivo;
import br.com.elotech.di.domain.Modulo;
import br.com.elotech.di.domain.aise.AiseAto;
import br.com.elotech.di.domain.aise.AiseModulo;
import br.com.elotech.di.replicate.aise.ReplicatorLeiAtoAiseAdditional;
import br.com.elotech.di.replicate.support.AbstractReplicator;
import br.com.elotech.di.replicate.support.ReplicateAise;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReplicatorLeiAtoAise
extends AbstractReplicator<LeiAto, Long, AiseAto>
implements ReplicateAise {
    @Autowired
    private ReplicatorLeiAtoAiseAdditional replicatorLeiAtoAiseAdditional;

    public void setReplicatorLeiAtoAiseAdditional(ReplicatorLeiAtoAiseAdditional replicatorLeiAtoAiseAdditional) {
        this.replicatorLeiAtoAiseAdditional = replicatorLeiAtoAiseAdditional;
    }

    public ReplicatorLeiAtoAiseAdditional getReplicatorLeiAtoAiseAdditional() {
        if (this.replicatorLeiAtoAiseAdditional == null) {
            throw new IllegalStateException("replicator additional null");
        }
        return this.replicatorLeiAtoAiseAdditional;
    }

    public AiseAto from(LeiAto unico, AiseAto legado) {
        legado.getId().setEntidade(this.getReplicatorFacade().getAiseEntidade(unico.getEntidade()));
        legado.setAnoAto(unico.getAno());
        legado.setIdUnico(unico.getId());
        legado.setNumeroAto(unico.getNumero());
        legado.setTipoAto(this.getReplicatorFacade().getAiseTipoLeiNatureza(unico.getTipoLeiNatureza()));
        legado.setTipoDocumentoLegal(this.getReplicatorFacade().getAiseTipoLeiDocumento(unico.getTipoLeiDocumento()));
        legado.setTipoEscopoLei(this.getReplicatorFacade().getAiseTipoLeiEscopo(unico.getTipoLeiEscopo()));
        legado.setAnoAto(unico.getAno());
        legado.setDataAto(unico.getDataAto());
        legado.setDataCadastro(unico.getDataCadastro());
        legado.setDataInicioVigencia(unico.getDataInicioVigencia());
        legado.setDataFimVigencia(unico.getDataFimVigencia());
        legado.setDataPublicacao(unico.getDataPublicacao());
        legado.setDescricao(unico.getSumula());
        legado.setEsfera(unico.getEsferaGoverno());
        legado.setIdTce(unico.getIdTce());
        legado.setNumeroAtoTce(unico.getNumeroTce());
        legado.setNumeroEdicao(unico.getNumeroEdicao());
        legado.setSituacao(unico.getSituacao());
        legado.setTipoAto(this.getReplicatorFacade().getAiseTipoLeiNatureza(unico.getTipoLeiNatureza()));
        legado.setTipoDocumentoLegal(this.getReplicatorFacade().getAiseTipoLeiDocumento(unico.getTipoLeiDocumento()));
        legado.setTipoEscopoLei(this.getReplicatorFacade().getAiseTipoLeiEscopo(unico.getTipoLeiEscopo()));
        legado.setAnoEdicao(unico.getAnoEdicao());
        legado.setDataGeracaoTc(unico.getDataGeracaoTC());
        legado.setAnoEdicao(unico.getAnoEdicao());
        if (Objects.nonNull(unico.getModulo()) && ModuloEnum.MODULO_SISCOP.getLongValue().equals(unico.getModulo().getId())) {
            legado.setModulo(null);
        } else {
            legado.setModulo(this.attrModulo(unico));
        }
        legado.setArquivo(null);
        LeiAtoArquivo arquivoPrincipal = unico.getArquivoPrincipal();
        if (arquivoPrincipal != null) {
            legado.setArquivo(arquivoPrincipal.getArquivo());
        }
        this.getReplicatorLeiAtoAiseAdditional().from(unico, legado);
        return legado;
    }

    private AiseModulo attrModulo(LeiAto unico) {
        if (Objects.isNull(unico.getModulo())) {
            return null;
        }
        return this.getReplicatorFacade().getAiseModulo(unico.getModulo());
    }

    public LeiAto to(AiseAto legado, LeiAto unico) {
        unico.setAno(Optional.ofNullable(legado.getAnoAto()).orElse(AiseAto.NUMERO_INVALIDO));
        unico.setNumero(Optional.ofNullable(legado.getNumeroAto()).orElse(AiseAto.NUMERO_INVALIDO));
        unico.setEntidade((Entidade)this.getReplicatorFacade().createReAttachEloDomain(Entidade.class, (Serializable)legado.getId().getEntidade().getIdUnico()));
        unico.setId(legado.getIdUnico());
        unico.setTipoLeiDocumento(this.getReplicatorFacade().getTipoLeiDocumentoByCodigo(legado.getTipoDocumentoLegalCodigo()));
        unico.setTipoLeiEscopo(this.getReplicatorFacade().getTipoLeiEscopoByCodigo(legado.getTipoEscopoLeiCodigo()));
        unico.setTipoLeiNatureza(this.getReplicatorFacade().getTipoLeiNaturezaByCodigo(legado.getTipoAtoCodigo()));
        unico.setSituacao(legado.getSituacao());
        unico.setIdTce(legado.getIdTce());
        unico.setDataAto(legado.getDataAto());
        unico.setDataInicioVigencia(legado.getDataInicioVigencia());
        unico.setDataFimVigencia(legado.getDataFimVigencia());
        unico.setSumula(legado.getDescricao());
        unico.setDataPublicacao(legado.getDataPublicacao());
        unico.setEsferaGoverno(legado.getEsfera());
        unico.setDataCadastro(legado.getDataCadastro());
        unico.setNumeroEdicao(legado.getNumeroEdicao());
        unico.setNumeroTce(legado.getNumeroAtoTce());
        unico.setNumeroEdicao(legado.getNumeroEdicao());
        unico.setAnoEdicao(legado.getAnoEdicao());
        unico.setDataGeracaoTC(legado.getDataGeracaoTc());
        if (legado.getArquivo() != null) {
            LeiAtoArquivo arquivo = new LeiAtoArquivo();
            arquivo.setArquivo(legado.getArquivo());
            arquivo.setPrincipal(Boolean.TRUE);
            unico.getArquivos().add(arquivo);
        }
        if (legado.getModulo() == null) {
            unico.setModulo(null);
        } else {
            unico.setModulo((Modulo)this.getReplicatorFacade().createReAttachEloDomain(Modulo.class, (Serializable)legado.getModulo().getIdUnico()));
        }
        this.getReplicatorLeiAtoAiseAdditional().to(legado, unico);
        return unico;
    }
}

