/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.replicate.aise;

import br.com.elotech.core.enumerable.common.EntidadeTipo;
import br.com.elotech.di.domain.Bairro;
import br.com.elotech.di.domain.Cidade;
import br.com.elotech.di.domain.Cnae;
import br.com.elotech.di.domain.Entidade;
import br.com.elotech.di.domain.Logradouro;
import br.com.elotech.di.domain.UF;
import br.com.elotech.di.domain.aise.AiseEntidade;
import br.com.elotech.di.replicate.support.AbstractReplicator;
import br.com.elotech.di.replicate.support.ReplicateAise;
import java.io.Serializable;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.BooleanUtils;
import org.springframework.stereotype.Component;

@Component
public class ReplicatorEntidadeAise
extends AbstractReplicator<Entidade, Long, AiseEntidade>
implements ReplicateAise {
    public AiseEntidade from(Entidade unico, AiseEntidade legado) {
        legado.setIdUnico(unico.getId());
        legado.setNome(unico.getNome());
        legado.setCnpj(unico.getCnpj());
        legado.setBrasao(unico.getBrasao());
        legado.setCarimboCarneCorreios(ArrayUtils.clone((byte[])unico.getCarimboCarneCorreios()));
        legado.setEntidadeConsole(unico.getEntidadeConsole());
        legado.setCep(unico.getCep());
        legado.setCnae(this.getReplicatorFacade().getAiseCnae(unico.getCnae()));
        legado.setCidade(this.getReplicatorFacade().getAiseCidade(unico.getCidade()));
        legado.setBairro(this.getReplicatorFacade().getAiseBairro(unico.getBairro()));
        legado.setComplemento(unico.getComplemento());
        legado.setContribuicaoPrevidenciaria(unico.getContribuicaoPrevidenciaria());
        legado.setEmail(unico.getEmail());
        legado.setEntidadePrincipal(unico.getEntidadePrincipal());
        legado.setFundoPrevidenciaSocial(unico.getFundoPrevidenciaSocial());
        legado.setIdentificacaoTCE(unico.getIdentificacaoTCE());
        legado.setLogradouro(this.getReplicatorFacade().getAiseLogradouro(unico.getLogradouro()));
        legado.setNumero(unico.getNumero());
        legado.setPercentualIsencaoFilantropica(unico.getPercentualIsencaoFilantropica());
        legado.setTelefone(unico.getTelefone());
        legado.setTipo(unico.getTipo());
        if (unico.getCidade() != null) {
            legado.setUnidadeFederacao(unico.getCidade().getUf().getSigla());
        }
        return legado;
    }

    public Entidade to(AiseEntidade legado, Entidade unico) {
        unico.setNome(legado.getNome());
        unico.setCnpj(legado.getCnpj());
        unico.setCep(legado.getCep());
        unico.setComplemento(legado.getComplemento());
        unico.setNumero(legado.getNumero());
        unico.setEmail(legado.getEmail());
        unico.setTelefone(legado.getTelefone());
        unico.setContribuicaoPrevidenciaria(legado.getContribuicaoPrevidenciaria());
        unico.setFundoPrevidenciaSocial(legado.getFundoPrevidenciaSocial());
        unico.setEntidadePrincipal(Boolean.valueOf(BooleanUtils.isTrue((Boolean)legado.getEntidadePrincipal())));
        unico.setIdentificacaoTCE(legado.getIdentificacaoTCE());
        unico.setTipo(EntidadeTipo.orDefault((EntidadeTipo)legado.getTipo()));
        unico.setBrasao(legado.getBrasao());
        unico.setCarimboCarneCorreios(ArrayUtils.clone((byte[])legado.getCarimboCarneCorreios()));
        unico.setPercentualIsencaoFilantropica(legado.getPercentualIsencaoFilantropica());
        if (legado.getCidade() != null) {
            unico.setCidade((Cidade)this.getReplicatorFacade().createReAttachEloDomain(Cidade.class, (Serializable)legado.getCidade().getIdUnico()));
            unico.getCidade().setUf((UF)this.getReplicatorFacade().createReAttachEloDomain(UF.class, (Serializable)legado.getCidade().getUf().getIdUnico()));
        }
        if (legado.getBairro() != null) {
            unico.setBairro((Bairro)this.getReplicatorFacade().createReAttachEloDomain(Bairro.class, (Serializable)legado.getBairro().getIdUnico()));
        }
        if (legado.getLogradouro() != null) {
            unico.setLogradouro((Logradouro)this.getReplicatorFacade().createReAttachEloDomain(Logradouro.class, (Serializable)legado.getLogradouro().getIdUnico()));
        }
        if (legado.getCnae() != null) {
            unico.setCnae((Cnae)this.getReplicatorFacade().createReAttachEloDomain(Cnae.class, (Serializable)legado.getCnae().getIdUnico()));
        }
        return unico;
    }
}

