/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.replicate.aise;

import br.com.elotech.di.domain.Cnae;
import br.com.elotech.di.domain.CnaeSituacao;
import br.com.elotech.di.domain.aise.AiseCnae;
import br.com.elotech.di.replicate.support.AbstractReplicator;
import br.com.elotech.di.replicate.support.ReplicateAise;
import org.apache.commons.lang.BooleanUtils;
import org.springframework.stereotype.Component;

@Component
public class ReplicatorCnaeAise
extends AbstractReplicator<Cnae, Long, AiseCnae>
implements ReplicateAise {
    public AiseCnae from(Cnae unico, AiseCnae legado) {
        legado.setAdmiteMovimento(unico.getAdmiteMovimento());
        legado.setCodigo(unico.getCodigo());
        legado.setDescricao(unico.getDescricao());
        legado.setIdUnico(unico.getId());
        legado.setGrauRisco(unico.getGrauRisco());
        legado.setClassificacaoAtividade(unico.getClassificacaoAtividade());
        legado.setInicioValidade(unico.getInicioValidade());
        if (unico.getSituacaoMei() != null) {
            legado.setSituacaoMei(unico.getSituacaoMei().getValue());
        }
        if (unico.getSituacaoSna() != null) {
            legado.setSituacaoSna(unico.getSituacaoSna().getValue());
        }
        legado.setValorBaseCalculo(unico.getValorBaseCalculo());
        return legado;
    }

    public Cnae to(AiseCnae legado, Cnae unico) {
        unico.setCodigo(legado.getCodigo());
        unico.setDescricao(legado.getDescricao());
        unico.setId(legado.getIdUnico());
        unico.setAdmiteMovimento(Boolean.valueOf(BooleanUtils.isTrue((Boolean)legado.getAdmiteMovimento())));
        unico.setGrauRisco(legado.getGrauRisco());
        unico.setClassificacaoAtividade(legado.getClassificacaoAtividade());
        unico.setInicioValidade(legado.getInicioValidade());
        unico.setSituacaoMei(CnaeSituacao.fromValue((String)legado.getSituacaoMei()));
        unico.setSituacaoSna(CnaeSituacao.fromValue((String)legado.getSituacaoSna()));
        unico.setValorBaseCalculo(legado.getValorBaseCalculo());
        return unico;
    }
}

