/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.replicate.aise;

import br.com.elotech.di.domain.Cidade;
import br.com.elotech.di.domain.UF;
import br.com.elotech.di.domain.aise.AiseCidade;
import br.com.elotech.di.replicate.support.AbstractReplicator;
import br.com.elotech.di.replicate.support.CidadeMerger;
import br.com.elotech.di.replicate.support.ReplicateAise;
import java.io.Serializable;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReplicatorCidadeAise
extends AbstractReplicator<Cidade, Long, AiseCidade>
implements ReplicateAise {
    private final CidadeMerger merger;

    @Autowired
    public ReplicatorCidadeAise(CidadeMerger merger) {
        this.merger = merger;
    }

    public AiseCidade from(Cidade unico, AiseCidade legado) {
        legado.setCodigoIbge(unico.getCodigoIbge());
        legado.setCodigoNacional(unico.getCodigoNacional());
        legado.setDescricao(unico.getDescricao());
        legado.setIdUnico(unico.getId());
        legado.setDescricaoAbreviada(unico.getDescricao());
        legado.setUf(this.getReplicatorFacade().getAiseUF(unico.getUf().getId()));
        legado.setAtiva(Boolean.valueOf(BooleanUtils.isFalse((Boolean)unico.getInativo())));
        return legado;
    }

    public Cidade to(AiseCidade legado, Cidade unico) {
        if (StringUtils.isBlank((String)legado.getDescricao())) {
            unico.setDescricao("CONVERSAO");
        } else {
            unico.setDescricao(legado.getDescricao());
        }
        unico.setId(legado.getIdUnico());
        unico.setCodigoIbge(legado.getCodigoIbge());
        unico.setCodigoNacional(legado.getCodigoNacional());
        unico.setInativo(Boolean.valueOf(BooleanUtils.isFalse((Boolean)legado.getAtiva())));
        if (legado.getUf() != null) {
            unico.setUf((UF)this.getReplicatorFacade().createReAttachEloDomain(UF.class, (Serializable)legado.getUf().getIdUnico()));
        } else {
            unico.setUf(UF.UF_INVALIDA);
        }
        return unico;
    }

    public Cidade merge(Cidade original, Cidade other) {
        return this.merger.merge(original, other);
    }
}

