/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.replicate.aise;

import br.com.elotech.di.domain.Bairro;
import br.com.elotech.di.domain.Cidade;
import br.com.elotech.di.domain.aise.AiseBairro;
import br.com.elotech.di.domain.aise.AiseBairroPK;
import br.com.elotech.di.domain.aise.AiseCidade;
import br.com.elotech.di.exception.UnableToChangePKException;
import br.com.elotech.di.replicate.support.AbstractReplicator;
import br.com.elotech.di.replicate.support.ReplicateAise;
import br.com.elotech.di.replicate.support.ReplicatorFacade;
import java.io.Serializable;
import org.springframework.stereotype.Component;

@Component
public class ReplicatorBairroAise
extends AbstractReplicator<Bairro, Long, AiseBairro>
implements ReplicateAise {
    public AiseBairro from(Bairro unico, AiseBairro legado) {
        legado.setIdUnico(unico.getId());
        legado.setDescricao(unico.getDescricao());
        legado.setInativo(unico.getInativo());
        AiseCidade cidade = this.getReplicatorFacade().getAiseCidade(unico.getCidade().getId());
        if (legado.getPk() == null) {
            legado.setPk(AiseBairroPK.create((AiseCidade)cidade));
        } else if (legado.getPk().getCidade() != null && !unico.getCidade().getId().equals(legado.getPk().getCidade().getIdUnico())) {
            throw new UnableToChangePKException(legado.getClass(), (Serializable)unico.getId());
        }
        return legado;
    }

    public Bairro to(AiseBairro legado, Bairro unico) {
        unico.setId(legado.getIdUnico());
        unico.setDescricao(ReplicatorFacade.defaultString((String)legado.getDescricao()));
        unico.setInativo(legado.getInativo());
        unico.setCidade((Cidade)this.getReplicatorFacade().createReAttachEloDomain(Cidade.class, (Serializable)legado.getPk().getCidade().getIdUnico()));
        return unico;
    }
}

