/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.replicate.aise;

import br.com.elotech.di.domain.Agencia;
import br.com.elotech.di.domain.Banco;
import br.com.elotech.di.domain.Cidade;
import br.com.elotech.di.domain.aise.AiseAgencia;
import br.com.elotech.di.domain.aise.AiseAgenciaPK;
import br.com.elotech.di.domain.aise.AiseBanco;
import br.com.elotech.di.exception.UnableToChangePKException;
import br.com.elotech.di.replicate.support.AbstractReplicator;
import br.com.elotech.di.replicate.support.ReplicateAise;
import java.io.Serializable;
import org.springframework.stereotype.Component;

@Component
public class ReplicatorAgenciaAise
extends AbstractReplicator<Agencia, Long, AiseAgencia>
implements ReplicateAise {
    public AiseAgencia from(Agencia unico, AiseAgencia legado) {
        legado.setIdUnico(unico.getId());
        legado.setNomeAgencia(unico.getDescricao());
        if (unico.getCidade() != null) {
            legado.setCidade(this.getReplicatorFacade().getAiseCidade(unico.getCidade().getId()));
        }
        AiseBanco banco = this.getReplicatorFacade().getAiseBanco(unico.getBanco().getId());
        if (legado.getPk() == null) {
            legado.setPk(AiseAgenciaPK.create((AiseBanco)banco).withCodigo(unico.getCodigo()));
        } else if (legado.getPk().getBanco() != null && !unico.getBanco().getId().equals(legado.getPk().getBanco().getIdUnico())) {
            throw new UnableToChangePKException(legado.getClass(), (Serializable)unico.getId());
        }
        return legado;
    }

    public Agencia to(AiseAgencia legado, Agencia unico) {
        unico.setDescricao(legado.getNomeAgencia());
        unico.setBanco((Banco)this.getReplicatorFacade().createReAttachEloDomain(Banco.class, (Serializable)legado.getPk().getBanco().getIdUnico()));
        unico.setCodigo(legado.getPk().getCodigo());
        if (legado.getCidade() != null) {
            unico.setCidade((Cidade)this.getReplicatorFacade().createReAttachEloDomain(Cidade.class, (Serializable)legado.getCidade().getIdUnico()));
        }
        return unico;
    }
}

