/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.outboxdataintegration.consumer;

import br.com.elotech.di.domain.Entidade;
import br.com.elotech.di.outboxdataintegration.consumer.EntidadeConsumer;
import br.com.elotech.di.outboxdataintegration.consumer.EntidadePayload;
import br.com.elotech.di.repository.Ceps;
import br.com.elotech.di.repository.Entidades;
import br.com.elotech.outbox.consumer.BaseConsumer;
import br.com.elotech.outbox.domain.EntityEvent;
import br.com.elotech.outbox.domain.OutboxActions;
import br.com.elotech.outbox.domain.OutboxEvent;
import br.com.elotech.outbox.hook.OutBoxBeforeProcessHook;
import br.com.elotech.outbox.publisher.Publisher;
import br.com.elotech.unico.client.dto.EntidadeDTO;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;

@RabbitListener(bindings={@QueueBinding(value=@Queue(value="OXY_CONSOLE_ENTIDADE_QUEUE_UNICO"), exchange=@Exchange(value="OXY_CONSOLE_ENTIDADE", type="topic"), key={""})}, errorHandler="errorHandler")
public class EntidadeConsumer
extends BaseConsumer<EntidadePayload> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntidadeConsumer.class);
    private final Entidades entidades;
    private final Ceps ceps;
    private final Publisher publisher;

    public EntidadeConsumer(List<OutBoxBeforeProcessHook> beforeHooks, ObjectMapper objectMapper, Entidades entidades, Ceps ceps, Publisher publisher) {
        super(beforeHooks, objectMapper);
        this.entidades = entidades;
        this.ceps = ceps;
        this.publisher = publisher;
    }

    public void process(OutboxEvent outboxEvent, EntidadePayload payload) {
        log.info("Iniciando consumo da entidade {} {}", (Object)outboxEvent.getAggregateType(), (Object)payload);
        switch (1.$SwitchMap$br$com$elotech$outbox$domain$OutboxActions[outboxEvent.getAction().ordinal()]) {
            case 1: {
                this.deleteEntidade(outboxEvent, payload);
                break;
            }
            case 2: {
                this.updateEntidade(outboxEvent, payload);
                break;
            }
            case 3: {
                this.createEntidade(outboxEvent, payload);
                break;
            }
            default: {
                log.warn("A\u00e7\u00e3o n\u00e3o reconhecida: {}", (Object)outboxEvent.getAction());
            }
        }
        log.info("Finalizando consumo da entidade {} {}", (Object)outboxEvent.getAggregateType(), (Object)payload);
    }

    private void createEntidade(OutboxEvent outboxEvent, EntidadePayload payload) {
        Entidade entity = new Entidade();
        this.setEntidadeProperties(entity, payload);
        this.entidades.saveAndFlush((Object)entity);
        this.publisher.publish(outboxEvent.getAction(), (EntityEvent)entity.convertToEvent());
    }

    private void updateEntidade(OutboxEvent outboxEvent, EntidadePayload payload) {
        Entidade entity = (Entidade)this.entidades.findByEntidadeConsole(payload.getId()).flatMap(e -> this.entidades.findById((Object)e.getId())).orElseThrow(() -> new IllegalArgumentException(String.format("Entidade com id %s n\u00e3o encontrada", payload.getId())));
        this.setEntidadeProperties(entity, payload);
        this.entidades.saveAndFlush((Object)entity);
        this.publisher.publish(outboxEvent.getAction(), (EntityEvent)entity.convertToEvent());
    }

    private void deleteEntidade(OutboxEvent outboxEvent, EntidadePayload payload) {
        Optional byEntidadeConsole = this.entidades.findByEntidadeConsole(payload.getId()).flatMap(e -> this.entidades.findById((Object)e.getId()));
        if (byEntidadeConsole.isPresent()) {
            Entidade entidade = (Entidade)byEntidadeConsole.get();
            EntidadeDTO event = entidade.convertToEvent();
            entidade.setAtivo(Boolean.FALSE);
            this.entidades.saveAndFlush((Object)entidade);
            this.publisher.publish(OutboxActions.UPDATED, (EntityEvent)event);
            log.debug("Entidade {} {} deletada", (Object)outboxEvent.getAggregateType(), (Object)payload);
        }
    }

    private void setEntidadeProperties(Entidade entity, EntidadePayload payload) {
        Optional.ofNullable(payload.getNome()).ifPresent(arg_0 -> ((Entidade)entity).setNome(arg_0));
        Optional.ofNullable(payload.getCnpj()).ifPresent(arg_0 -> ((Entidade)entity).setCnpj(arg_0));
        entity.setAtivo(payload.getAtivo());
        Optional.ofNullable(payload.getEndereco()).ifPresent(enderecoDTO -> {
            Optional.ofNullable(enderecoDTO.getComplemento()).ifPresent(arg_0 -> ((Entidade)entity).setComplemento(arg_0));
            Optional.ofNullable(enderecoDTO.getNumero()).ifPresent(arg_0 -> ((Entidade)entity).setNumero(arg_0));
            Optional.ofNullable(enderecoDTO.getCep()).ifPresent(arg_0 -> ((Entidade)entity).setCep(arg_0));
        });
        Optional.ofNullable(entity.getCep()).flatMap(arg_0 -> ((Ceps)this.ceps).findByCodigo(arg_0)).ifPresent(cep -> entity.setCidade(cep.getCidade()));
        Optional.ofNullable(payload.getId()).ifPresent(arg_0 -> ((Entidade)entity).setEntidadeConsole(arg_0));
    }
}

