/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.liquibase;

import br.com.elotech.core.security.PasswordEncoderConfiguration;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.UUID;
import liquibase.change.custom.CustomSqlChange;
import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.crypto.password.PasswordEncoder;

public class CreateRootUser
implements CustomSqlChange {
    private static final String APPLICATION_ROOT_PASSWORD = "application.root";
    private static final String ROOT_USER = "root";
    private static final Logger LOG = LoggerFactory.getLogger(CreateRootUser.class);
    private static final int USR_GRUPO = 1;
    private static final int ADM_GRUPO = 2;
    private static final Long ROOT_USER_ID = 0L;
    private final String password;
    private final String encodedPassword;
    private String schema;

    public CreateRootUser() {
        PasswordEncoder passwordEncoder = new PasswordEncoderConfiguration().getDefaultPasswordEncoder();
        this.password = UUID.randomUUID().toString();
        this.encodedPassword = passwordEncoder.encode((CharSequence)this.password);
    }

    public String getConfirmationMessage() {
        return "Root user created.";
    }

    public SqlStatement[] generateStatements(Database database) {
        this.writeRootUserPasswordFile();
        String sqlCreateUser = String.format("INSERT INTO %s.USUARIO (ID, USUARIO, SENHA, ATIVO)  VALUES (%d, '%s', '%s', 'S')", this.schema, ROOT_USER_ID, ROOT_USER, this.encodedPassword);
        String sqlSetRoleUser = String.format("INSERT INTO %s.USUARIOGRUPO (USUARIO, GRUPO) VALUES (%d, %d)", this.schema, ROOT_USER_ID, 2);
        String sqlSetRoleAdmin = String.format("INSERT INTO %s.USUARIOGRUPO (USUARIO, GRUPO) VALUES (%d, %d)", this.schema, ROOT_USER_ID, 1);
        String sqlSetUsuarioModulo = String.format("INSERT INTO %s.USUARIOMODULO (ID, USUARIO, MODULO, PRINCIPAL) SELECT MODULO, %d, MODULO, 'N' from %s.MODULO", this.schema, ROOT_USER_ID, this.schema);
        return new SqlStatement[]{new RawSqlStatement(sqlCreateUser), new RawSqlStatement(sqlSetRoleUser), new RawSqlStatement(sqlSetRoleAdmin), new RawSqlStatement(sqlSetUsuarioModulo)};
    }

    public void setUp() {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return new ValidationErrors();
    }

    private void writeRootUserPasswordFile() {
        LOG.info("\n\nRoot password: " + this.password + "\n");
        File file = new File(APPLICATION_ROOT_PASSWORD);
        try (FileWriter writer = new FileWriter(file);){
            writer.append(this.password);
        }
        catch (IOException ex) {
            LOG.warn(String.format("Cannot create root user password file %s", file), (Throwable)ex);
        }
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }
}

