/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.jpa.support;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import javax.persistence.EmbeddedId;
import javax.persistence.metamodel.Metamodel;
import org.springframework.data.jpa.repository.support.JpaMetamodelEntityInformation;
import org.springframework.data.util.DirectFieldAccessFallbackBeanWrapper;

public class EloJpaEntityInformation<T, K extends Serializable>
extends JpaMetamodelEntityInformation<T, K> {
    public EloJpaEntityInformation(Class<T> domainClass, Metamodel metamodel) {
        super(domainClass, metamodel);
    }

    public boolean isNew(T entity) {
        Serializable id = (Serializable)this.getId(entity);
        Class idType = this.getIdType();
        if (!idType.isPrimitive()) {
            if (this.isEmbeddedId(entity) && id != null) {
                return this.embeddedIdHasNullValues(id, idType);
            }
            return id == null;
        }
        if (id instanceof Number) {
            return ((Number)id).longValue() == 0L;
        }
        throw new IllegalArgumentException(String.format("Unsupported primitive id type %s!", idType));
    }

    private boolean isEmbeddedId(Object entity) {
        ArrayList idAttributeNames = Lists.newArrayList((Iterable)this.getIdAttributeNames());
        if (idAttributeNames.size() == 1) {
            Field idField = entity.getClass().getDeclaredField((String)idAttributeNames.get(0));
            return idField.isAnnotationPresent(EmbeddedId.class);
        }
        return false;
    }

    private boolean embeddedIdHasNullValues(K id, Class<K> idType) {
        Field[] declaredFields;
        DirectFieldAccessFallbackBeanWrapper entityWrapper = new DirectFieldAccessFallbackBeanWrapper(id);
        for (Field field : declaredFields = idType.getDeclaredFields()) {
            Object idValue;
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) || (idValue = entityWrapper.getPropertyValue(field.getName())) != null) continue;
            return true;
        }
        return false;
    }
}

