/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.jpa.hibernate;

import br.com.elotech.core.repository.support.EmStatelessSession;
import br.com.elotech.di.domain.support.EloDomain;
import br.com.elotech.di.jpa.support.EloJpaEntityInformation;
import java.io.Serializable;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.springframework.beans.BeanUtils;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class HibernateUtils {
    private HibernateUtils() {
    }

    private static <T> T reAttachToSession(Class<T> classType, T entity, Serializable id, EntityManager em) {
        Session session = (Session)em.unwrap(Session.class);
        if (session.contains(entity)) {
            return entity;
        }
        SessionImplementor sessionImplementor = (SessionImplementor)em.unwrap(SessionImplementor.class);
        EntityPersister persister = sessionImplementor.getEntityPersister(classType.getName(), entity);
        EntityKey entityKey = sessionImplementor.generateEntityKey(id, persister);
        if (sessionImplementor.getPersistenceContext().containsEntity(entityKey)) {
            return (T)session.get(classType, id);
        }
        session.buildLockRequest(LockOptions.NONE).lock(entity);
        return entity;
    }

    public static <T> T reAttachToSession(EntityManagerFactory emf, T entity) {
        EntityManager em = EntityManagerFactoryUtils.getTransactionalEntityManager((EntityManagerFactory)emf);
        return (T)HibernateUtils.reAttachToSession(entity, (EntityManager)em);
    }

    public static <T> T reAttachToSession(T entity, EntityManager em) {
        Class<?> classType = entity.getClass();
        return (T)HibernateUtils.reAttachToSession(classType, entity, (EntityManager)em);
    }

    public static <K extends Serializable, T extends EloDomain<K>> T createReAttachEloDomain(Class<T> clazz, K id, EntityManager em) {
        Session session = (Session)em.unwrap(Session.class);
        EloDomain result = (EloDomain)session.get(clazz, id);
        if (result == null) {
            result = (EloDomain)BeanUtils.instantiateClass(clazz);
            result.setId(id);
            HibernateUtils.reAttachToSession(clazz, (Object)result, id, (EntityManager)em);
        }
        return (T)result;
    }

    public static <T> T reAttachToSession(Class<T> classType, T entity, EntityManager em) {
        EloJpaEntityInformation jpaEntityInformation = new EloJpaEntityInformation(classType, em.getMetamodel());
        Serializable id = (Serializable)jpaEntityInformation.getId(entity);
        return (T)HibernateUtils.reAttachToSession(classType, entity, (Serializable)id, (EntityManager)em);
    }

    public static <K extends Serializable, T extends EloDomain<K>> T getForceFromDatabase(Class<T> clazz, K id, EntityManagerFactory emf) {
        return (T)((EloDomain)new EmStatelessSession(emf).getFromDatabase(clazz, id));
    }
}

