/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.health;

import br.com.elotech.di.batch.job.JobUtils;
import java.util.List;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"!cloud"})
public class HealthBatch
implements HealthIndicator {
    @Autowired
    private JobExplorer jobExplorer;
    @Autowired
    private JobUtils jobUtils;
    private String jobName = "Unifica\u00e7\u00e3o";

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobName() {
        return this.jobName;
    }

    public Health health() {
        List jobsInstances = this.jobExplorer.getJobInstances(this.jobName, 0, Integer.MAX_VALUE);
        if (jobsInstances.isEmpty()) {
            return Health.down().build();
        }
        JobExecution lastJobExecution = this.jobUtils.getLastJobExecution(this.jobName);
        if (lastJobExecution.getStatus().isUnsuccessful() || lastJobExecution.getStatus() == BatchStatus.STOPPED) {
            return Health.down().withDetail("Steps ", (Object)this.jobUtils.getFailureSteps(lastJobExecution)).build();
        }
        return Health.up().build();
    }
}

