/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.dto;

import br.com.elotech.di.dto.StatusRepublishDTO;
import br.com.elotech.di.dto.enums.ExchangesEnum;
import br.com.elotech.di.dto.enums.StatusPublishEnum;
import br.com.elotech.di.utils.SecurityUtils;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.math.NumberUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class StatusRepublishDTO
implements Serializable {
    private String key;
    private String descricao;
    private ExchangesEnum exchange;
    private StatusPublishEnum status;
    private String nomeUsuario;
    private String filtros;
    @JsonFormat(pattern="dd/MM/yyyy HH:mm:ss")
    private LocalDateTime dataCriacao;
    @JsonFormat(pattern="dd/MM/yyyy HH:mm:ss")
    private LocalDateTime dataAtualizacao;
    private String erro;
    private String stackTrace;
    private Integer quantidadeTotal;
    private Integer quantidadeExecutada;

    public static StatusRepublishDTO buildObject(ExchangesEnum exchangesEnum, String filtros) {
        return StatusRepublishDTO.builder().nomeUsuario(SecurityUtils.getNome()).filtros(filtros).exchange(exchangesEnum).descricao(exchangesEnum.getDescricao()).status(StatusPublishEnum.PARADO).dataAtualizacao(LocalDateTime.now()).dataCriacao(LocalDateTime.now()).quantidadeExecutada(NumberUtils.INTEGER_ZERO).key(String.format("FILA-topic(%s)-t(%s)", exchangesEnum.getNome(), TenantContextHolder.getCurrentTenantId())).build();
    }

    public double getPercentual() {
        if (this.quantidadeTotal == 0) {
            return 0.0;
        }
        return BigDecimal.valueOf(this.getQuantidadeExecutada() * 100).divide(BigDecimal.valueOf(this.getQuantidadeTotal().intValue()), RoundingMode.HALF_EVEN).doubleValue();
    }

    public void incrementAndGet() {
        Integer n = this.quantidadeExecutada;
        this.quantidadeExecutada = this.quantidadeExecutada + 1;
    }

    public void iniciar() {
        this.status = StatusPublishEnum.INICIANDO;
    }

    public void executar(StatusPublishEnum status) {
        this.status = status.equals((Object)StatusPublishEnum.CANCELANDO) ? StatusPublishEnum.CANCELANDO : StatusPublishEnum.EXECUTANDO;
    }

    public StatusPublishEnum finalizar(StatusPublishEnum statusRecuperado) {
        if (statusRecuperado == StatusPublishEnum.CANCELANDO) {
            this.status = StatusPublishEnum.CANCELADO;
            return this.status;
        }
        this.status = Objects.equals(this.quantidadeExecutada, this.quantidadeTotal) ? StatusPublishEnum.FINALIZADO : StatusPublishEnum.FINALIZADO_COM_ERRO;
        return this.status;
    }

    public void cancelando() {
        this.status = StatusPublishEnum.CANCELANDO;
        this.key = this.key + "-CANCELADO";
    }

    public void cancelar() {
        this.status = StatusPublishEnum.CANCELADO;
    }

    public <K extends Serializable> StatusRepublishDTO handleErro(Exception e, K id, StatusPublishEnum status) {
        if (status == StatusPublishEnum.CANCELANDO) {
            this.status = StatusPublishEnum.CANCELANDO;
        }
        this.stackTrace = ExceptionUtils.getStackTrace((Throwable)e);
        this.erro = String.format("O erro ocorreu na entidade %s do id %s", this.descricao, id);
        return this;
    }

    public StatusRepublishDTO atualizar() {
        this.dataAtualizacao = LocalDateTime.now();
        return this;
    }

    @Generated
    private static Integer $default$quantidadeTotal() {
        return NumberUtils.INTEGER_ZERO;
    }

    @Generated
    private static Integer $default$quantidadeExecutada() {
        return NumberUtils.INTEGER_ZERO;
    }

    @Generated
    public static StatusRepublishDTOBuilder builder() {
        return new StatusRepublishDTOBuilder();
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public ExchangesEnum getExchange() {
        return this.exchange;
    }

    @Generated
    public StatusPublishEnum getStatus() {
        return this.status;
    }

    @Generated
    public String getNomeUsuario() {
        return this.nomeUsuario;
    }

    @Generated
    public String getFiltros() {
        return this.filtros;
    }

    @Generated
    public LocalDateTime getDataCriacao() {
        return this.dataCriacao;
    }

    @Generated
    public LocalDateTime getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Generated
    public String getErro() {
        return this.erro;
    }

    @Generated
    public String getStackTrace() {
        return this.stackTrace;
    }

    @Generated
    public Integer getQuantidadeTotal() {
        return this.quantidadeTotal;
    }

    @Generated
    public Integer getQuantidadeExecutada() {
        return this.quantidadeExecutada;
    }

    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setExchange(ExchangesEnum exchange) {
        this.exchange = exchange;
    }

    @Generated
    public void setStatus(StatusPublishEnum status) {
        this.status = status;
    }

    @Generated
    public void setNomeUsuario(String nomeUsuario) {
        this.nomeUsuario = nomeUsuario;
    }

    @Generated
    public void setFiltros(String filtros) {
        this.filtros = filtros;
    }

    @JsonFormat(pattern="dd/MM/yyyy HH:mm:ss")
    @Generated
    public void setDataCriacao(LocalDateTime dataCriacao) {
        this.dataCriacao = dataCriacao;
    }

    @JsonFormat(pattern="dd/MM/yyyy HH:mm:ss")
    @Generated
    public void setDataAtualizacao(LocalDateTime dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Generated
    public void setErro(String erro) {
        this.erro = erro;
    }

    @Generated
    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    @Generated
    public void setQuantidadeTotal(Integer quantidadeTotal) {
        this.quantidadeTotal = quantidadeTotal;
    }

    @Generated
    public void setQuantidadeExecutada(Integer quantidadeExecutada) {
        this.quantidadeExecutada = quantidadeExecutada;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatusRepublishDTO)) {
            return false;
        }
        StatusRepublishDTO other = (StatusRepublishDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$quantidadeTotal = this.getQuantidadeTotal();
        Integer other$quantidadeTotal = other.getQuantidadeTotal();
        if (this$quantidadeTotal == null ? other$quantidadeTotal != null : !((Object)this$quantidadeTotal).equals(other$quantidadeTotal)) {
            return false;
        }
        Integer this$quantidadeExecutada = this.getQuantidadeExecutada();
        Integer other$quantidadeExecutada = other.getQuantidadeExecutada();
        if (this$quantidadeExecutada == null ? other$quantidadeExecutada != null : !((Object)this$quantidadeExecutada).equals(other$quantidadeExecutada)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$descricao = this.getDescricao();
        String other$descricao = other.getDescricao();
        if (this$descricao == null ? other$descricao != null : !this$descricao.equals(other$descricao)) {
            return false;
        }
        ExchangesEnum this$exchange = this.getExchange();
        ExchangesEnum other$exchange = other.getExchange();
        if (this$exchange == null ? other$exchange != null : !this$exchange.equals(other$exchange)) {
            return false;
        }
        StatusPublishEnum this$status = this.getStatus();
        StatusPublishEnum other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$nomeUsuario = this.getNomeUsuario();
        String other$nomeUsuario = other.getNomeUsuario();
        if (this$nomeUsuario == null ? other$nomeUsuario != null : !this$nomeUsuario.equals(other$nomeUsuario)) {
            return false;
        }
        String this$filtros = this.getFiltros();
        String other$filtros = other.getFiltros();
        if (this$filtros == null ? other$filtros != null : !this$filtros.equals(other$filtros)) {
            return false;
        }
        LocalDateTime this$dataCriacao = this.getDataCriacao();
        LocalDateTime other$dataCriacao = other.getDataCriacao();
        if (this$dataCriacao == null ? other$dataCriacao != null : !((Object)this$dataCriacao).equals(other$dataCriacao)) {
            return false;
        }
        LocalDateTime this$dataAtualizacao = this.getDataAtualizacao();
        LocalDateTime other$dataAtualizacao = other.getDataAtualizacao();
        if (this$dataAtualizacao == null ? other$dataAtualizacao != null : !((Object)this$dataAtualizacao).equals(other$dataAtualizacao)) {
            return false;
        }
        String this$erro = this.getErro();
        String other$erro = other.getErro();
        if (this$erro == null ? other$erro != null : !this$erro.equals(other$erro)) {
            return false;
        }
        String this$stackTrace = this.getStackTrace();
        String other$stackTrace = other.getStackTrace();
        return !(this$stackTrace == null ? other$stackTrace != null : !this$stackTrace.equals(other$stackTrace));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StatusRepublishDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $quantidadeTotal = this.getQuantidadeTotal();
        result = result * 59 + ($quantidadeTotal == null ? 43 : ((Object)$quantidadeTotal).hashCode());
        Integer $quantidadeExecutada = this.getQuantidadeExecutada();
        result = result * 59 + ($quantidadeExecutada == null ? 43 : ((Object)$quantidadeExecutada).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $descricao = this.getDescricao();
        result = result * 59 + ($descricao == null ? 43 : $descricao.hashCode());
        ExchangesEnum $exchange = this.getExchange();
        result = result * 59 + ($exchange == null ? 43 : $exchange.hashCode());
        StatusPublishEnum $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $nomeUsuario = this.getNomeUsuario();
        result = result * 59 + ($nomeUsuario == null ? 43 : $nomeUsuario.hashCode());
        String $filtros = this.getFiltros();
        result = result * 59 + ($filtros == null ? 43 : $filtros.hashCode());
        LocalDateTime $dataCriacao = this.getDataCriacao();
        result = result * 59 + ($dataCriacao == null ? 43 : ((Object)$dataCriacao).hashCode());
        LocalDateTime $dataAtualizacao = this.getDataAtualizacao();
        result = result * 59 + ($dataAtualizacao == null ? 43 : ((Object)$dataAtualizacao).hashCode());
        String $erro = this.getErro();
        result = result * 59 + ($erro == null ? 43 : $erro.hashCode());
        String $stackTrace = this.getStackTrace();
        result = result * 59 + ($stackTrace == null ? 43 : $stackTrace.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "StatusRepublishDTO(key=" + this.getKey() + ", descricao=" + this.getDescricao() + ", exchange=" + String.valueOf(this.getExchange()) + ", status=" + String.valueOf(this.getStatus()) + ", nomeUsuario=" + this.getNomeUsuario() + ", filtros=" + this.getFiltros() + ", dataCriacao=" + String.valueOf(this.getDataCriacao()) + ", dataAtualizacao=" + String.valueOf(this.getDataAtualizacao()) + ", erro=" + this.getErro() + ", stackTrace=" + this.getStackTrace() + ", quantidadeTotal=" + this.getQuantidadeTotal() + ", quantidadeExecutada=" + this.getQuantidadeExecutada() + ")";
    }

    @Generated
    public StatusRepublishDTO() {
        this.quantidadeTotal = StatusRepublishDTO.$default$quantidadeTotal();
        this.quantidadeExecutada = StatusRepublishDTO.$default$quantidadeExecutada();
    }

    @Generated
    public StatusRepublishDTO(String key, String descricao, ExchangesEnum exchange, StatusPublishEnum status, String nomeUsuario, String filtros, LocalDateTime dataCriacao, LocalDateTime dataAtualizacao, String erro, String stackTrace, Integer quantidadeTotal, Integer quantidadeExecutada) {
        this.key = key;
        this.descricao = descricao;
        this.exchange = exchange;
        this.status = status;
        this.nomeUsuario = nomeUsuario;
        this.filtros = filtros;
        this.dataCriacao = dataCriacao;
        this.dataAtualizacao = dataAtualizacao;
        this.erro = erro;
        this.stackTrace = stackTrace;
        this.quantidadeTotal = quantidadeTotal;
        this.quantidadeExecutada = quantidadeExecutada;
    }
}

