/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.support;

import br.com.elotech.core.config.DBConfigProperties;
import br.com.elotech.di.domain.Entidade;
import br.com.elotech.di.domain.Usuario;
import br.com.elotech.di.domain.UsuarioEntidade;
import br.com.elotech.di.domain.support.EloDomain;
import br.com.elotech.di.service.EntidadeService;
import br.com.elotech.di.service.UsuarioService;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class UsuarioSupport {
    private static final int NIVEL_USUARIO = 7;
    public static final String SQL_INSERT_AISE = "INSERT INTO %s.USUARIOSELETORGERAL (MODULO, SELETOR, USUARIO, FAVORITO, INSERIR, ALTERAR, EXCLUIR, FUNCAOESPECIAL) VALUES ('%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s')";
    public static final String SQL_INSERT_SISCOP = "INSERT INTO %s.USRXPROG(USUARIO, MODULO, PROGRAMA, ACESSO, INSERIR, ALTERAR, EXCLUIR, FUNCAOESPECIAL) VALUES ('%s', '%s', '%s', %d, '%s', '%s', '%s', '%s')";
    public static final String SQL_INSERT_COMPRAS = "INSERT INTO %s.USUARIOSELETOR(MODULO, SELETOR, USUARIO, AUTOGRAVA, REAPROVEITA, ACESSO, AUTOINSERI, INSERIR, ALTERAR, EXCLUIR, FUNCAOESPECIAL) VALUES ('%s', '%s' , '%s', '%s', '%s', %d, '%s', '%s', '%s', '%s', '%s')";
    public static final String SQL_INSERT_PROTOCOLO = "INSERT INTO %s.USUARIOSELETOR(MODULO, SELETOR, USUARIO, AUTOGRAVA, REAPROVEITA, ACESSO, AUTOINSERI, INSERIR, ALTERAR, EXCLUIR, FUNCAOESPECIAL) VALUES ('%s', '%s' , '%s', '%s', '%s', %d, '%s', '%s', '%s', '%s', '%s')";
    public static final String ROOT_USER = "root";
    @Autowired
    private UsuarioService usuarioService;
    @Autowired
    private EntidadeService entidadeService;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private DBConfigProperties dbConfigProperties;

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void setUsuarioService(UsuarioService service) {
        this.usuarioService = service;
    }

    public void setEntidadeService(EntidadeService entidadeService) {
        this.entidadeService = entidadeService;
    }

    public void setDbConfigProperties(DBConfigProperties dbConfigProperties) {
        this.dbConfigProperties = dbConfigProperties;
    }

    @Transactional
    public void attrPermissaoAndEntidades(String userId) {
        Iterable all = this.usuarioService.findAllByHashStringIsNull();
        for (Usuario usuario : all) {
            if (usuario.getUsuario().equals(userId)) {
                this.atribuiEntidadesUsuario(usuario);
            }
            this.usuarioService.saveAndFlush((EloDomain)usuario);
            if (!usuario.getUsuario().equals(userId)) continue;
            this.atribuirPermissoesLegado(userId);
        }
    }

    private void atribuirPermissoesLegado(String userId) {
        this.jdbcTemplate.execute(String.format(SQL_INSERT_AISE, this.dbConfigProperties.getAise().getSchema(), "90", "TFrm_Permissao", userId, "N", "S", "S", "S", "N"));
        this.jdbcTemplate.execute(String.format(SQL_INSERT_AISE, this.dbConfigProperties.getAise().getSchema(), "90", "TFrm_PermissaoEspecial", userId, "N", "S", "S", "S", "N"));
        this.jdbcTemplate.execute(String.format(SQL_INSERT_SISCOP, this.dbConfigProperties.getContabilidade().getSchema(), userId, "3", "Frm_Usuario", 7, "S", "S", "S", "S"));
        this.jdbcTemplate.execute(String.format("INSERT INTO %s.USUARIOSELETOR(MODULO, SELETOR, USUARIO, AUTOGRAVA, REAPROVEITA, ACESSO, AUTOINSERI, INSERIR, ALTERAR, EXCLUIR, FUNCAOESPECIAL) VALUES ('%s', '%s' , '%s', '%s', '%s', %d, '%s', '%s', '%s', '%s', '%s')", this.dbConfigProperties.getCompras().getSchema(), "10", "Frm_PermissaoAcesso", userId, "N", "N", 7, "N", "S", "S", "S", "S"));
        this.jdbcTemplate.execute(String.format("INSERT INTO %s.USUARIOSELETOR(MODULO, SELETOR, USUARIO, AUTOGRAVA, REAPROVEITA, ACESSO, AUTOINSERI, INSERIR, ALTERAR, EXCLUIR, FUNCAOESPECIAL) VALUES ('%s', '%s' , '%s', '%s', '%s', %d, '%s', '%s', '%s', '%s', '%s')", this.dbConfigProperties.getProtocolo().getSchema(), "4", "Frm_AcessoPrograma", userId, "N", "N", 7, "N", "S", "S", "S", "S"));
    }

    private void atribuiEntidadesUsuario(Usuario usuario) {
        Page all = this.entidadeService.findAll((Pageable)PageRequest.of((int)0, (int)Integer.MAX_VALUE));
        for (Entidade entidade : all) {
            UsuarioEntidade usuarioEntidade = new UsuarioEntidade();
            usuarioEntidade.setEntidade(entidade);
            usuarioEntidade.setPrincipal(Boolean.FALSE);
            usuario.getEntidades().add(usuarioEntidade);
        }
        if (!usuario.getEntidades().isEmpty()) {
            ((UsuarioEntidade)usuario.getEntidades().get(0)).setPrincipal(Boolean.TRUE);
        }
    }
}

