/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.support;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.core.metamodel.annotation.ToModel;
import br.com.elotech.di.replicate.support.ReplicatorFacade;
import br.com.elotech.di.validation.SkipBatchValidation;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import org.hibernate.validator.constraints.Length;

@MappedSuperclass
@ToModel(exclude={"sourceClass", "hashString"})
@SkipBatchValidation
public abstract class EloDomain<K extends Serializable>
implements EloEntity<K> {
    @Length(max=50)
    @Caption(value="sourceClass")
    @Column(updatable=false)
    private @Length(max=50) String sourceClass;
    private String hashString;
    public static final String DESCRICAO_DEFAULT = "CONVERSAO";

    @JsonIgnore
    public String getSourceClass() {
        return this.sourceClass;
    }

    public void setSourceClass(String sourceClass) {
        this.sourceClass = sourceClass;
    }

    @JsonIgnore
    public boolean isNew() {
        return this.getId() == null;
    }

    public EloDomain<K> withId(K id) {
        this.setId(id);
        return this;
    }

    public String hashString() {
        if (this.getId() == null) {
            return UUID.randomUUID().toString();
        }
        return ReplicatorFacade.hashCodeString((String)this.getClass().getSimpleName()) + ReplicatorFacade.hashCodeEloEntity((EloEntity)this);
    }

    @JsonIgnore
    @Length(max=500)
    @Column(name="hashString")
    public @Length(max=500) String getHashString() {
        this.hashString = this.hashString();
        return this.hashString;
    }
}

