/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.siscop;

import br.com.elotech.di.domain.siscop.SiscopModulo;
import br.com.elotech.di.domain.siscop.SiscopUsuario;
import br.com.elotech.di.domain.siscop.SiscopUsuarioModulo;
import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.validation.Valid;
import lombok.Generated;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="siscop.usrxmod")
@DynamicInsert
@DynamicUpdate
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="ehcache")
public class SiscopUsuarioModulo {
    @EmbeddedId
    @Valid
    private final SiscopUsuarioModuloPK pk = new SiscopUsuarioModuloPK();
    private Boolean prioritario;
    private LocalDateTime ultimoAcesso;
    @Column(length=20)
    @Length(max=20)
    private @Length(max=20) String root;

    public SiscopUsuarioModuloPK getPk() {
        return this.pk;
    }

    public Boolean getPrioritario() {
        return this.prioritario;
    }

    public void setPrioritario(Boolean prioritario) {
        this.prioritario = prioritario;
    }

    public static SiscopUsuarioModulo of(SiscopUsuario usuario, SiscopModulo modulo) {
        return new SiscopUsuarioModulo().withUsuario(usuario).withModulo(modulo);
    }

    public SiscopUsuarioModulo withModulo(SiscopModulo modulo) {
        this.pk.setModulo(modulo);
        return this;
    }

    public SiscopUsuarioModulo withUsuario(SiscopUsuario usuario) {
        this.pk.setUsuario(usuario);
        return this;
    }

    public SiscopUsuarioModulo withPrioritario(Boolean prioritario) {
        this.setPrioritario(prioritario);
        return this;
    }

    public LocalDateTime getUltimoAcesso() {
        return this.ultimoAcesso;
    }

    public void setUltimoAcesso(LocalDateTime ultimoAcesso) {
        this.ultimoAcesso = ultimoAcesso;
    }

    public String getRoot() {
        return this.root;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SiscopUsuarioModulo)) {
            return false;
        }
        SiscopUsuarioModulo other = (SiscopUsuarioModulo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        SiscopUsuarioModuloPK this$pk = this.getPk();
        SiscopUsuarioModuloPK other$pk = other.getPk();
        return !(this$pk == null ? other$pk != null : !this$pk.equals(other$pk));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SiscopUsuarioModulo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SiscopUsuarioModuloPK $pk = this.getPk();
        result = result * 59 + ($pk == null ? 43 : $pk.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SiscopUsuarioModulo(pk=" + String.valueOf(this.getPk()) + ", prioritario=" + this.getPrioritario() + ", ultimoAcesso=" + String.valueOf(this.getUltimoAcesso()) + ", root=" + this.getRoot() + ")";
    }
}

