/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.siscop;

import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.di.domain.siscop.SiscopEntidade;
import br.com.elotech.di.domain.siscop.SiscopUsuario;
import br.com.elotech.di.domain.siscop.SiscopUsuarioEntidadePK;
import javax.persistence.Convert;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.validation.Valid;
import lombok.Generated;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

@Entity
@Table(name="siscop.usuario_entidade")
@DynamicInsert
@DynamicUpdate
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="ehcache")
public class SiscopUsuarioEntidade {
    @EmbeddedId
    @Valid
    private final SiscopUsuarioEntidadePK pk = new SiscopUsuarioEntidadePK();
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean padrao;

    public Boolean getPadrao() {
        return this.padrao;
    }

    public void setPadrao(Boolean padrao) {
        this.padrao = padrao;
    }

    public SiscopUsuarioEntidadePK getPk() {
        return this.pk;
    }

    public static SiscopUsuarioEntidade of(SiscopUsuario usuario, SiscopEntidade entidade) {
        return new SiscopUsuarioEntidade().withUsuario(usuario).withEntidade(entidade);
    }

    public SiscopUsuarioEntidade withEntidade(SiscopEntidade entidade) {
        this.pk.setEntidade(entidade);
        return this;
    }

    public SiscopUsuarioEntidade withUsuario(SiscopUsuario usuario) {
        this.pk.setUsuario(usuario);
        return this;
    }

    public SiscopUsuarioEntidade withPadrao(Boolean padrao) {
        this.setPadrao(padrao);
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SiscopUsuarioEntidade)) {
            return false;
        }
        SiscopUsuarioEntidade other = (SiscopUsuarioEntidade)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        SiscopUsuarioEntidadePK this$pk = this.getPk();
        SiscopUsuarioEntidadePK other$pk = other.getPk();
        return !(this$pk == null ? other$pk != null : !this$pk.equals(other$pk));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SiscopUsuarioEntidade;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SiscopUsuarioEntidadePK $pk = this.getPk();
        result = result * 59 + ($pk == null ? 43 : $pk.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SiscopUsuarioEntidade(pk=" + String.valueOf(this.getPk()) + ", padrao=" + this.getPadrao() + ")";
    }
}

