/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.siscop;

import br.com.elotech.core.utils.Cipher;
import br.com.elotech.di.domain.Usuario;
import br.com.elotech.di.domain.siscop.SiscopUsuarioEntidade;
import br.com.elotech.di.domain.siscop.SiscopUsuarioModulo;
import br.com.elotech.di.replicate.support.Replicable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.Valid;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="siscop.usuario")
@DynamicInsert
@DynamicUpdate
public class SiscopUsuario
implements Replicable<Usuario, Long> {
    private static final String ROOT_TEST = "ROOT";
    private static final long NIVEL_USUARIO = 9999L;
    @Id
    @Column(name="usuario")
    @Length(max=250)
    private @Length(max=250) String id;
    @Column(length=150)
    @Length(max=150)
    private @Length(max=150) String nome;
    @Column(length=15)
    @Length(max=15)
    private @Length(max=15) String senha;
    private Long nivel = 9999L;
    private Long tempo;
    private Long tempoReqFec;
    private Long tempoReq;
    @Column(length=20)
    @Length(max=20)
    private @Length(max=20) String root;
    private Boolean ativo;
    @Column(length=20)
    @Length(max=20)
    private @Length(max=20) String cpf;
    @Column(length=20)
    @Length(max=20)
    private @Length(max=20) String rg;
    @Column(length=20)
    @Length(max=20)
    private @Length(max=20) String orgaoEmissor;
    @Column(length=60)
    @Length(max=60)
    private @Length(max=60) String descricaoCargo;
    @Column(length=30)
    @Length(max=30)
    private @Length(max=30) String matricula;
    @Column(length=1)
    @Length(max=1)
    private @Length(max=1) String tipoOrdem;
    private Boolean operadorcoletor;
    @Length(max=100)
    private @Length(max=100) String email;
    private Long idUnico;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="pk.usuario")
    @Valid
    private final Set<SiscopUsuarioEntidade> entidades = new HashSet();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="pk.usuario")
    @Valid
    private final Set<SiscopUsuarioModulo> modulos = new HashSet();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSenha() {
        return this.senha;
    }

    public void setSenha(String senha) {
        this.senha = senha;
    }

    public Long getNivel() {
        return this.nivel;
    }

    public void setNivel(Long nivel) {
        this.nivel = nivel;
    }

    public Long getTempo() {
        return this.tempo;
    }

    public void setTempo(Long tempo) {
        this.tempo = tempo;
    }

    public Long getTempoRefFec() {
        return this.tempoReqFec;
    }

    public void setTempoRefFec(Long tempoRefFec) {
        this.tempoReqFec = tempoRefFec;
    }

    public Long getTempoReq() {
        return this.tempoReq;
    }

    public void setTempoReq(Long tempoReq) {
        this.tempoReq = tempoReq;
    }

    public String getRoot() {
        return this.root;
    }

    public Boolean getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String cpf) {
        this.cpf = cpf;
    }

    public String getRg() {
        return this.rg;
    }

    public void setRg(String rg) {
        this.rg = rg;
    }

    public String getOrgaoEmissor() {
        return this.orgaoEmissor;
    }

    public void setOrgaoEmissor(String orgaoEmissor) {
        this.orgaoEmissor = orgaoEmissor;
    }

    public String getDescricaoCargo() {
        return this.descricaoCargo;
    }

    public void setDescricaoCargo(String descricaoCargo) {
        this.descricaoCargo = descricaoCargo;
    }

    public String getMatricula() {
        return this.matricula;
    }

    public void setMatricula(String matricula) {
        this.matricula = matricula;
    }

    public String getTipoOrdem() {
        return this.tipoOrdem;
    }

    public void setTipoOrdem(String tipoOrdem) {
        this.tipoOrdem = tipoOrdem;
    }

    public Boolean getOperadorcoletor() {
        return this.operadorcoletor;
    }

    public void setOperadorcoletor(Boolean operadorcoletor) {
        this.operadorcoletor = operadorcoletor;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setIdUnico(Long idUnico) {
        this.idUnico = idUnico;
    }

    public Long getIdUnico() {
        return this.idUnico;
    }

    public Set<SiscopUsuarioEntidade> getEntidades() {
        return this.entidades;
    }

    public Set<SiscopUsuarioModulo> getModulos() {
        return this.modulos;
    }

    public SiscopUsuario withSenha(String senha) {
        this.setSenha(senha);
        return this;
    }

    public SiscopUsuario withAtivo(Boolean ativo) {
        this.setAtivo(ativo);
        return this;
    }

    @Transient
    public boolean isRoot() {
        if (this.root == null || this.id == null) {
            return false;
        }
        return ROOT_TEST.equals(Cipher.encrypt((String)this.root, (String)this.id)) && this.modulos.stream().allMatch(mod -> ROOT_TEST.equals(Cipher.encrypt((String)mod.getRoot(), (String)this.id)));
    }

    public void maskAsRoot() {
        this.setRoot(Cipher.encrypt((String)ROOT_TEST, (String)this.id));
        this.modulos.stream().forEach(mod -> mod.setRoot(Cipher.encrypt((String)ROOT_TEST, (String)this.id)));
    }

    public void setRoot(String root) {
        this.root = root;
    }

    @Generated
    public String toString() {
        return "SiscopUsuario(id=" + this.getId() + ", nome=" + this.getNome() + ", cpf=" + this.getCpf() + ", idUnico=" + this.getIdUnico() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SiscopUsuario)) {
            return false;
        }
        SiscopUsuario other = (SiscopUsuario)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SiscopUsuario;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

