/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.siscop;

import br.com.elotech.di.domain.TipoDocumento;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

/*
 * Exception performing whole class analysis ignored.
 */
public enum SiscopTipoDocumento {
    FGTS(Long.valueOf(0L), "FGTS", TipoDocumento.FGTS),
    INSS(Long.valueOf(1L), "INSS", TipoDocumento.INSS),
    CNDT(Long.valueOf(2L), "CNDT", TipoDocumento.CNDT),
    ESTADUAL(Long.valueOf(3L), "Estadual", TipoDocumento.ESTADUAL),
    FEDERAL(Long.valueOf(4L), "Federal", TipoDocumento.FEDERAL),
    OUTROS(Long.valueOf(5L), "Outros", TipoDocumento.OUTROS),
    MUNICIPAL(Long.valueOf(6L), "Municipal", TipoDocumento.MUNICIPAL),
    CREA(Long.valueOf(7L), "CREA", TipoDocumento.CREA),
    TCE(Long.valueOf(8L), "TCE", TipoDocumento.TCE);

    private final Long codigo;
    private final String descricao;
    private final TipoDocumento tipoDocumento;
    private static final Map<TipoDocumento, SiscopTipoDocumento> TO_SISCOP_TIPO_DOCUMENTO;

    public TipoDocumento getTipoDocumento() {
        return this.tipoDocumento;
    }

    private SiscopTipoDocumento(Long codigo, String descricao, TipoDocumento tipoDocumento) {
        this.codigo = codigo;
        this.descricao = descricao;
        this.tipoDocumento = tipoDocumento;
    }

    public Long getCodigo() {
        return this.codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public static SiscopTipoDocumento getByCodigo(long codigo) {
        for (SiscopTipoDocumento siscopTipoDocumento : SiscopTipoDocumento.values()) {
            if (!siscopTipoDocumento.getCodigo().equals(codigo)) continue;
            return siscopTipoDocumento;
        }
        return OUTROS;
    }

    public static SiscopTipoDocumento getToTipoDocumento(TipoDocumento tipoDocumento) {
        return TO_SISCOP_TIPO_DOCUMENTO.getOrDefault(tipoDocumento, OUTROS);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (SiscopTipoDocumento siscoTipoDocumento : SiscopTipoDocumento.values()) {
            builder.put((Object)siscoTipoDocumento.tipoDocumento, (Object)siscoTipoDocumento);
        }
        TO_SISCOP_TIPO_DOCUMENTO = builder.build();
    }
}

