/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.domain.siscop;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.di.domain.TipoLeiNatureza;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="siscop.naturezalei")
@DynamicInsert
@DynamicUpdate
public class SiscopNaturezaLei
implements EloEntity<Long> {
    private static final Map<Long, Long> TO_UNICO;
    @Id
    private Long id;
    @NotNull
    private Long codigo;
    @NotEmpty
    @Column(length=250)
    @Length(max=250)
    private @NotEmpty @Length(max=250) String descricao;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getCodigo() {
        return this.codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setCodigo(Long codigo) {
        this.codigo = codigo;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public static SiscopNaturezaLei of(Long id) {
        return new SiscopNaturezaLei().withId(id);
    }

    public SiscopNaturezaLei withId(Long id) {
        this.setId(id);
        return this;
    }

    public Long toTipoLeiNaturezaCodigo() {
        return (Long)TO_UNICO.get(this.codigo);
    }

    @Generated
    public String toString() {
        return "SiscopNaturezaLei(id=" + this.getId() + ", codigo=" + this.getCodigo() + ", descricao=" + this.getDescricao() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SiscopNaturezaLei)) {
            return false;
        }
        SiscopNaturezaLei other = (SiscopNaturezaLei)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SiscopNaturezaLei;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)TipoLeiNatureza.SISCOP_LEI, (Object)TipoLeiNatureza.UNICO_LEI);
        builder.put((Object)TipoLeiNatureza.SISCOP_DECRETO, (Object)TipoLeiNatureza.UNICO_DECRETO);
        builder.put((Object)TipoLeiNatureza.SISCOP_ATO_CONSELHO, (Object)TipoLeiNatureza.UNICO_OUTROS);
        builder.put((Object)TipoLeiNatureza.SISCOP_RESOLUCAO, (Object)TipoLeiNatureza.UNICO_RESOLUCAO);
        builder.put((Object)TipoLeiNatureza.SISCOP_OUTROS, (Object)TipoLeiNatureza.UNICO_OUTROS);
        builder.put((Object)TipoLeiNatureza.SISCOP_PORTARIA, (Object)TipoLeiNatureza.UNICO_PORTARIA);
        TO_UNICO = builder.build();
    }
}

